% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PD_distribution.R
\name{dPD}
\alias{dPD}
\title{The Poisson-Dirichlet distribution}
\usage{
dPD(abund, psi)
}
\arguments{
\item{abund}{An abundance vector.}

\item{psi}{Dispersal parameter \eqn{\psi}. Accepted input values are positive real
numbers, "a" for absolute value \eqn{\psi}=1 by default, or "r" for relative
value \eqn{\psi=n}, where \eqn{n} is the size of the input sample.}
}
\value{
The probability of the Poisson-Dirichlet distribution for the input
abundance vector, e.g. an exchangeable random partition,  and a dispersal parameter \eqn{\psi}.
}
\description{
Distribution function for the Poisson-Dirichlet distribution.
}
\details{
Given an abundance vector \code{abunds}, calculates the probability
of a data vector \code{x} given by the Poisson-Dirichlet distribution. The higher the
dispersal parameter \eqn{\psi}, the higher the amount of distinct observed
species. In terms of the paintbox process, a high \eqn{\psi} increases the
size of the continuous part \eqn{p_0} of the process, while a low \eqn{\psi} will increase
the size of the discrete parts \eqn{p_{\neq 0}}.
}
\examples{
## Get a random sample from the Poisson Dirichlet distribution, and
## find the probability of such a sample with psi=5:
set.seed(111)
s <- rPD(n=100,psi=5)
a=abundance(s)
dPD(a, psi=5)

}
\references{
W.J. Ewens, The sampling theory of selectively neutral alleles, Theoretical Population Biology, Volume 3, Issue 1,
1972, Pages 87-112, ISSN 0040-5809, <\doi{10.1016/0040-5809(72)90035-4}>.
}
\keyword{Poisson-Dirichlet}
\keyword{distribution}
