% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covtest.pe.comp.R
\name{covtest.pe.comp}
\alias{covtest.pe.comp}
\title{Two-sample PE covariance test for high-dimensional data via PE component}
\usage{
covtest.pe.comp(dataX,dataY,delta=NULL)
}
\arguments{
\item{dataX}{an \eqn{n_1} by \eqn{p} data matrix}

\item{dataY}{an \eqn{n_2} by \eqn{p} data matrix}

\item{delta}{a scalar; the thresholding value used in the construction of
the PE component. If not specified, the function uses a default value
\eqn{\delta_{cov}=4\log(\log (n_1+n_2))\log p}.}
}
\value{
\code{stat} the value of test statistic

\code{pval} the p-value for the test.
}
\description{
This function implements the two-sample PE covariance test via the
construction of the PE component. Let \eqn{T_{LC}/\hat\sigma_{T_{LC}}}
denote the \eqn{l_2}-norm-based covariance test statistic
(see \code{\link{covtest.lc}} for details).
The PE component is constructed by
\deqn{J_c=\sqrt{p}\sum_{i=1}^p\sum_{j=1}^p T_{ij}\widehat\xi^{-1/2}_{ij}
\mathcal{I}\{ \sqrt{2}T_{ij}\widehat\xi^{-1/2}_{ij} +1 >  \delta_{cov} \}, }
where \eqn{\delta_{cov}} is a threshold for the screening procedure,
recommended to take the value of \eqn{\delta_{cov}=4\log(\log (n_1+n_2))\log p}.
The explicit forms of \eqn{T_{ij}} and \eqn{\widehat\xi_{ij}}
can be found in Section 3.2 of Yu et al. (2022).
The PE covariance test statistic is defined as
\deqn{T_{PE}=T_{LC}/\hat\sigma_{T_{LC}}+J_c.}
With some regularity conditions, under the null hypothesis
\eqn{H_{0c}: \mathbf{\Sigma}_1 = \mathbf{\Sigma}_2},
the test statistic \eqn{T_{PE}} converges in distribution to
a standard normal distribution as \eqn{n_1, n_2, p \rightarrow \infty}.
The asymptotic \eqn{p}-value is obtained by
\deqn{p\text{-value}=1-\Phi(T_{PE}),}
where \eqn{\Phi(\cdot)} is the cdf of the standard normal distribution.
}
\examples{
n1 = 100; n2 = 100; pp = 500
set.seed(1)
X = matrix(rnorm(n1*pp), nrow=n1, ncol=pp)
Y = matrix(rnorm(n2*pp), nrow=n2, ncol=pp)
covtest.pe.comp(X,Y)
}
\references{
Yu, X., Li, D., Xue, L., and Li, R. (2022). Power-enhanced simultaneous test
of high-dimensional mean vectors and covariance matrices with application
to gene-set testing. \emph{Journal of the American Statistical Association},
(in press):1–14.
}
