% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PJFM_wrapper.R
\name{PJFM_prediction}
\alias{PJFM_prediction}
\title{The function to calculate predicted probabilities}
\usage{
PJFM_prediction(
  res = NULL,
  RecurData_test = NULL,
  SurvData_test = NULL,
  control_list = NULL,
  t_break = 1,
  tau = 0.5
)
}
\arguments{
\item{res}{a model fit returned by PJFM_fit; the prediction
only works the returned model fit is JFM, but not PJFM.}

\item{RecurData_test}{a data frame containing the recurrent events data on the test dataset
(see \code{\link{RecurData}}).}

\item{SurvData_test}{a data frame containing the survival data on the test dataset
(see \code{\link{SurvData}}).}

\item{control_list}{a list of parameters specifying the joint frailty model
(see \code{\link{control_list}}).}

\item{t_break}{the landmark time point}

\item{tau}{the prediction window (i.e., (t_break, t_break+tau]).}
}
\value{
return a data frame, which contains all the variables in SurvData_test as well as t_break, tau, and risk.
The column risk indicates the predicted probability of event in the given prediction window.
}
\description{
The function is used to calculate predicted probabilities.
}
\examples{
require(splines)
data(PJFMdata)

up_limit = ceiling(max(SurvData$ftime))
bs_fun <- function(t=NULL){
    bs(t, knots = NULL, degree = 2, intercept = TRUE, Boundary.knots= c(0,up_limit))
}

recur_fix_time_fun = bs_fun
recur_ran_time_fun <- function(x=NULL){
    xx = cbind(1, matrix(x, ncol = 1))
    colnames(xx) = c("intercept","year_1")
    xx[,1,drop=FALSE]
    #xx
}

surv_fix_time_fun = bs_fun

control_list = list(
    ID_name = "ID", item_name = "feature_id",
    time_name = "time", fix_cov = "x", random_cov = NULL,
    recur_fix_time_fun = recur_fix_time_fun,
    recur_ran_time_fun = recur_ran_time_fun,
    surv_fix_time_fun = surv_fix_time_fun,
    surv_time_name = "ftime",  surv_status_name = "fstat",
    surv_cov = "x", n_points = 5
)

\donttest{
train_id = 1:200
test_id = 200:300

SurvData_test = SurvData[is.element(SurvData$ID, test_id), ]
RecurData_test = RecurData[is.element(RecurData$ID, test_id), ]

SurvData = SurvData[is.element(SurvData$ID, train_id), ]
RecurData = RecurData[is.element(RecurData$ID, train_id), ]

## this step takes a few minutes.
## analyze the first 10 recurrent events
res = PJFM_fit(RecurData=RecurData, SurvData=SurvData,
               control_list=control_list, EventName=1:10)


## get prediction probabilities
pred_scores = PJFM_prediction(res=res,RecurData_test=RecurData_test,
                              SurvData_test=SurvData_test,control_list=control_list,
                              t_break = 1, tau = 0.5)

}

}
\references{
Jiehuan Sun. "Dynamic Prediction with Penalized Joint Frailty Model of High-Dimensional Recurrent Event Data and a Survival Outcome".
}
