% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p.sort.R
\name{p.sort}
\alias{p.sort}
\title{Sort and truncate predictors according to the strength of predictor-environment interaction}
\usage{
p.sort(x, y, method = "linear", n.pred = ncol(x), trunc = 1)
}
\arguments{
\item{x}{A data matrix (raw: samples, col: predictors).}

\item{y}{A vector of an environment in which the samples were collected.}

\item{method}{A string to specify the method of regression for calculating R-squared values.
"linear" (default), "quadratic" or "cubic" regression model can be specified.}

\item{n.pred}{The number of predictors to be included in PLORN model (default: ncol(x)).}

\item{trunc}{a threshold to be truncated (default: 1).}
}
\value{
A data matrix (raw: samples, col: sorted predictors)
}
\description{
Sort and truncate predictors according to the strength of predictor-environment interaction
}
\examples{
data(Pinus)
train <- p.clean(Pinus$train)
target <- Pinus$target
cor(target, train[, 1])

train <- p.sort(train, target, trunc = 0.5)
cor(target, train[, 1])
}
\author{
Takahiko Koizumi
}
