% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phylo_regression.R
\name{genome_content_phylo_regress}
\alias{genome_content_phylo_regress}
\title{Phylogenetic regression of input vector against function presence/absence.}
\usage{
genome_content_phylo_regress(y, func, in_tree, ncores = 1, model_type = "BM")
}
\arguments{
\item{y}{variable to use for y component of model. Typically would be either a binary vector indicating which taxa are significantly different, or the normalized specicity or normalized prevalence values.
Must be a named numeric vector with names matching the rows of the func dataframe.
These names also must match the tree tip labels, but they can be a subset and any missing tips will be dropped.}

\item{func}{dataframe of the number of copies of each function that are encoded by each input taxon.
This pipeline only considers the presence/absence of functions across taxa.
Taxa (with row names intersecting with the "abun" table) should be the rows and the functions should be the columns.}

\item{in_tree}{phylo object. Tip labels must include the row names of the func dataframe and the names of the y input vector.}

\item{ncores}{integer specifying how many cores to use for parallelized sections of pipeline.}

\item{model_type}{length-one character vector specifying which phylogenetic model to use (must be a possible setting of the model argument to the phylolm function).}
}
\value{
Dataframe summarizing the phylolm coefficients and model p-values for each y ~ function comparison.
Will include the intercept, slope, and p-value for each case. Row names will be function ids.
}
\description{
Runs phylogenetic regression with phylolm on each function (or trait) in the specified function table.
}
