% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phylogenize_modified.R
\name{prevalence_norm_logit}
\alias{prevalence_norm_logit}
\title{Compute additive smoothed prevalence of features (e.g, taxa), restricted to samples of a particular metadata category.\cr}
\usage{
prevalence_norm_logit(
  abun_table,
  meta_table,
  focal_var_level,
  var_colname,
  sample_colname,
  silence_citation = FALSE
)
}
\arguments{
\item{abun_table}{abundance table to use for computing prevalence. Features must be rows and samples columns. All values greater than 0 will be interpreted as present.}

\item{meta_table}{dataframe object containing metadata for all samples. Must include at least one column corresponding to the sample ids and one column containing the metadata of interest that will be focused on when computing prevalence.}

\item{focal_var_level}{length-one character vector specifying the variable value to restrict inferences of prevalence to. In other words, prevalence will be computed based on the sample set that contain this value of the variable of interest in the metadata table.}

\item{var_colname}{length-one character vector specifying the name of column in the metadata table that contains the metadata of interest (e.g., where focal_var_level can be found).}

\item{sample_colname}{length-one character vector specifying the name of column in the metadata table that contains the sample ids.}

\item{silence_citation}{length-one Boolean vector specifying whether to silence message notifying user about phylogenize package and paper.}
}
\value{
Numeric vector with the normalized prevalence score for each input feature (i.e., for each row of abun_table).
}
\description{
This code replicates the prevalence score introduced in phylogenize. The code here is modified from the phylogenize code base
(https://bitbucket.org/pbradz/phylogenize/src/master/package/phylogenize/R/; commit 6f1bdba9c5a9ff04e90a8ad77bcee8ec9281730d).
}
\details{
This algorithm is descibed in detail in Bradley et al. 2018. Phylogeny-corrected identification of microbial gene families relevant to human gut colonization. PLOS Computational Biology.
}
