% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poset_from_dataframe.R
\name{poset_from_dataframe}
\alias{poset_from_dataframe}
\title{Generates a Partially Ordered SET from a data frame through the component-wise comparability relation}
\usage{
poset_from_dataframe(x, collapse = "-")
}
\arguments{
\item{x}{an object of class \code{data.frame}.}

\item{collapse}{an object of class \code{character} that defines the separator between observations with the same profile, by default \code{"-"}.  For more information see the details section.}
}
\value{
an S4 object of class \code{Rcpp_POSet}; this class contains different C++ methods used by other functions of the package.
}
\description{
This function generates a poset from an object \code{x} of class \code{data.frame} that lists by rows all the observations in a statistical population and by columns the values of different orderable variables (i.e. vectors of class \code{ordered} or \code{numeric}).
}
\details{
The poset is generated through the component-wise comparability relation \insertCite{davey2002introduction}{POSetR}. Note that some observations may have the same profile (i.e. the same values for all the variables) therefore they have to be included into the same element of the poset, than the label of such element correspond to the labels of the statistical units separated by the \code{collapse} character.
}
\examples{
set <- ordered(letters[1:5])
set.seed(0)
n <- 30
x <- data.frame(
  A = sample(set, n, replace = TRUE),
  B = sample(set, n, replace = TRUE),
  C = sample(set, n, replace = TRUE)
)

p <- poset_from_dataframe(x, collapse = ",")

plot(p, equispaced = TRUE, vertex.frame.color = "lightgray", vertex.color = "lightgray")
}
\references{
\insertRef{davey2002introduction}{POSetR}
}
\seealso{
\code{\link[POSetR]{poset}}.
}
