% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Pfit.R
\name{Pfit}
\alias{Pfit}
\alias{Pfit.gpcm}
\title{Person-Fit statistics}
\usage{
Pfit(respm, pp, fitindices, SE = FALSE)

\method{Pfit}{gpcm}(respm, pp, fitindices = c("infit", "outfit"), SE = FALSE)
}
\arguments{
\item{respm}{numeric response matrix}

\item{pp}{object of the class fourpl with estimated person parameter}

\item{fitindices}{character vector of desired person fit statistics c("lz","lzstar","infit","outfit")}

\item{SE}{logical: if true standard errors are computed using jackknife method}
}
\value{
list of person-fits for each person-fit statistic

\itemize{
\item the list of person-fits contains the calculated person-fit (like lz, lzstar) and also additional information like p-value or standard error if desired.
\item the additional information is provided after the short form of the personfit
\item lz (lz)
\item lzstar (lzs)
\item infit the mean-square statistic (in)
\item outfit the mean-square statistic (ou)
\item _unst: unstandardised
\item _se: standard error
\item _t: t-value
\item _chisq: $chi^2$-value
\item _df: defrees of freedom
\item _pv: p-value
}
}
\description{
Compute several person fit statistic for the 1-PL, 2-PL, 3-PL, 4-PL and PCM.
}
\details{
Please note that currently only the likelihood based LZ-Index (Drasgow, Levine, and Williams, 1985) and LZ*-Index (Snijders, 2001) are implemented. Also the INFIT-OUTIFT (Wright and Masters, 1982, 1990) statistic as well as the polytomouse version of INFIT-OUTFIT are supported. Other person fit statistics will be added soon.

The calculation of the person fit statistics requires the numeric response-matrix as well as an object of the fourpl-class. So first you should estimate the person parameter and afterwards calculate the person fit statistics. You could also use our PPass-function to estimate the person parameter and calculate the desired person fit simultaneously.
It is possible to calculate several person fit statistics at once, you only have to specify them in a vector.

For the Partial Credit model we currently support the infit-outfit statistic. Please submit also the numeric response-matrix as well as the estimated person parameter with an gpcm-class.
}
\examples{
################# Pfit ###################################################


### data creation ##########

set.seed(1337)


# intercepts
diffpar <- seq(-3,3,length=15)
# slope parameters
sl     <- round(runif(15,0.5,1.5),2)
la     <- round(runif(15,0,0.25),2)
ua     <- round(runif(15,0.8,1),2)

# response matrix
awm <- matrix(sample(0:1,100*15,replace=TRUE),ncol=15)

# ------------------------------------------------------------------------
## 1PL model ##### 
# ------------------------------------------------------------------------
# MLE
res1plmle <- PP_4pl(respm = awm,thres = diffpar,type = "mle")
# WLE
res1plwle <- PP_4pl(respm = awm,thres = diffpar,type = "wle")
# MAP estimation
res1plmap <- PP_4pl(respm = awm,thres = diffpar,type = "map")
# ------------------------------------------------------------------------
## LZ*-Index ##### 
Pfit(respm=awm,pp=res1plwle,fitindices="lzstar")
Pfit(respm=awm,pp=res1plmle,fitindices="lzstar")
Pfit(respm=awm,pp=res1plmap,fitindices="lzstar")
## LZ*-Index combined with Infit-Outfit ##### 
Pfit(respm=awm,pp=res1plwle,fitindices=c("lzstar","infit","outfit"))
# ------------------------------------------------------------------------

##########################################################################

# ------------------------------------------------------------------------
## 2PL model ##### 
# ------------------------------------------------------------------------
# MLE
res2plmle <- PP_4pl(respm = awm,thres = diffpar, slopes = sl,type = "mle")
# WLE
res2plwle <- PP_4pl(respm = awm,thres = diffpar, slopes = sl,type = "wle")
# ------------------------------------------------------------------------
## LZ*-Index ##### 
Pfit(respm=awm,pp=res2plwle,fitindices="lzstar")
Pfit(respm=awm,pp=res2plmle,fitindices="lzstar")
## LZ*-Index combined with Infit-Outfit ##### 
Pfit(respm=awm,pp=res2plwle,fitindices=c("lzstar","infit","outfit"))
# ------------------------------------------------------------------------

##########################################################################

# ------------------------------------------------------------------------
## 3PL model ##### 
# ------------------------------------------------------------------------
# MLE
res3plmle <- PP_4pl(respm = awm,thres = diffpar,
                    slopes = sl,lowerA = la,type = "mle")
# WLE
res3plwle <- PP_4pl(respm = awm,thres = diffpar,
                    slopes = sl,lowerA = la,type = "wle")
# ------------------------------------------------------------------------
## LZ*-Index ##### 
Pfit(respm=awm,pp=res3plwle,fitindices="lzstar")
Pfit(respm=awm,pp=res3plmle,fitindices="lzstar")
## LZ*-Index combined with Infit-Outfit ##### 
Pfit(respm=awm,pp=res3plwle,fitindices=c("lzstar","infit","outfit"))
# ------------------------------------------------------------------------

##########################################################################

# ------------------------------------------------------------------------
## 4PL model ##### 
# ------------------------------------------------------------------------
# MLE
res4plmle <- PP_4pl(respm = awm,thres = diffpar,
                    slopes = sl,lowerA = la,upperA=ua,type = "mle")
# WLE
res4plwle <- PP_4pl(respm = awm,thres = diffpar,
                    slopes = sl,lowerA = la,upperA=ua,type = "wle")
# ------------------------------------------------------------------------
## LZ*-Index ##### 
Pfit(respm=awm,pp=res4plwle,fitindices="lzstar")
Pfit(respm=awm,pp=res4plmle,fitindices="lzstar")
## LZ*-Index combined with Infit-Outfit ##### 
Pfit(respm=awm,pp=res4plwle,fitindices=c("lzstar","infit","outfit"))
# ------------------------------------------------------------------------

##########################################################################
}
\references{
Armstrong, R. D., Stoumbos, Z. G., Kung, M. T. & Shi, M. (2007). On the performance of the lz person-fit statistic.  \emph{Practical Assessment, Research & Evaluation}, \bold{12(16)}. Chicago	

De La Torre, J., & Deng, W. (2008). Improving Person-Fit Assessment by Correcting the Ability Estimate and Its Reference Distribution. Journal of Educational Measurement, \bold{45(2)}, 159-177.

Drasgow, F., Levine, M. V. & Williams, E. A. (1985) Appropriateness measurement with polychotomous item response models and standardized indices. \emph{British Journal of Mathematical and Statistical Psychology}, \bold{38(1)}, 67--86.

Efron, B., & Stein, C. (1981). The jackknife estimate of variance. \emph{The Annals of Statistics}, \bold{9(3)}, 586-596.	

Karabatsos, G. (2003) Comparing the Aberrant Response Detection Performance of Thirty-Six Person-Fit Statistics. \emph{Applied Measurement In Education}, \bold{16(4)}, 277--298.

Magis, D., Raiche, G. & Beland, S. (2012) A didactic presentation of Snijders's l[sub]z[/sub] index of person fit with emphasis on response model selection and ability estimation. \emph{Journal of Educational and Behavioral Statistics}, \bold{37(1)}, 57--81.

Meijer, R. R. & Sijtsma, K. (2001) Methodology review: Evaluating person fit. \emph{Applied Psychological Measurement}, \bold{25(2)}, 107--135.

Molenaar, I. W. & Hoijtink, H. (1990) The many null distributions of person fit indices. \emph{Psychometrika}, \bold{55(1)}, 75--106. 

Mousavi, A. & Cui, Y. Evaluate the performance of and of person fit: A simulation study.

Reise, S. P. (1990). A comparison of item-and person-fit methods of assessing model-data fit in IRT.  \emph{Applied Psychological Measurement}, \bold{14(2)}, 127-137.

Snijders, T. B. (2001) Asymptotic null distribution of person fit statistics with estimated person parameter. \emph{Psychometrika}, \bold{66(3)}, 331--342. 

Wright, B. D. & Masters, G. N. (1990). Computation of OUTFIT and INFIT Statistics.  \emph{Rasch Measurement Transactions}, 3:4, 84-85.

Wright, B. D., & Masters, G. N. (1982). \emph{Rating Scale Analysis. Rasch Measurement.} MESA Press, 5835 S. Kimbark Avenue, Chicago, IL 60637.
}
\seealso{
\link{PPall}, \link{PP_4pl}, \link{PPass}
}
\author{
Jan Steinfeld
}
\keyword{Infit-Outfit}
\keyword{LZ-Index}
\keyword{Person}
\keyword{fit}
