% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linking_functions.R
\name{runCalibration}
\alias{runCalibration}
\title{Run Calibration}
\usage{
runCalibration(
  data,
  dimensions = 1,
  fix_method = "free",
  fixedpar = NULL,
  ignore_nonconv = FALSE,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{data}{a \code{\linkS4class{PROsetta_data}} object. See \code{\link{loadData}} for loading a dataset.}

\item{dimensions}{the number of dimensions to use. Must be 1 or 2.
If 1, use one underlying dimension for all instruments combined.
If 2, use each dimension separately for the anchor instrument and the developing instrument. Covariance between dimensions is freely estimated. (default = \code{1})}

\item{fix_method}{the type of constraints to impose. (default = \code{free})
\itemize{
  \item{\code{item} for fixed parameter calibration using anchor item parameters}
  \item{\code{theta} for using the mean and the variance obtained from a unidimensional calibration of anchor items}
  \item{\code{free} for free calibration}
}}

\item{fixedpar}{this argument exists for backward compatibility. \code{TRUE} is equivalent to \code{fix_method = "item"}, and \code{FALSE} is equivalent to \code{fix_method = "free"}.}

\item{ignore_nonconv}{if \code{TRUE}, return results even when calibration does not converge. If \code{FALSE}, raise an error when calibration does not converge. (default = \code{FALSE})}

\item{verbose}{if \code{TRUE}, print status messages. (default = \code{FALSE})}

\item{...}{additional arguments to pass onto \code{\link[mirt]{mirt}} in \href{https://CRAN.R-project.org/package=mirt}{'mirt'} package.}
}
\value{
\code{\link{runCalibration}} returns a \code{\link[mirt:SingleGroupClass-class]{SingleGroupClass}} object containing item calibration results.

This object can be used in \code{\link[mirt:coef-method]{coef}}, \code{\link[mirt]{itemfit}}, \code{\link[mirt]{itemplot}} in \href{https://CRAN.R-project.org/package=mirt}{'mirt'} package to extract wanted information.
}
\description{
\code{\link{runCalibration}} is a function for performing item parameter calibration on the response data.
}
\examples{
\dontrun{
out_calib <- runCalibration(data_asq) # errors
}
\donttest{
out_calib <- runCalibration(data_asq, technical = list(NCYCLES = 1000))

mirt::coef(out_calib, IRTpars = TRUE, simplify = TRUE)
mirt::itemfit(out_calib, empirical.plot = 1)
mirt::itemplot(out_calib, item = 1, type = "info")
mirt::itemfit(out_calib, "S_X2", na.rm = TRUE)
}
}
