% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search.R
\name{search_comments}
\alias{search_comments}
\title{Search Pushshift.io for Reddit comments}
\usage{
search_comments(
  q = "",
  subreddit = NULL,
  size = 25,
  after = NULL,
  before = NULL,
  parse_date = TRUE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{q}{character, Query term}

\item{subreddit}{Restrict results to subreddit (use "!" to negate, comma delimited for multiples)}

\item{size}{integer, Number of results to return}

\item{after}{integer, Restrict results to those made after this epoch time}

\item{before}{integer, Restrict results to those made before this epoch time}

\item{parse_date}{logical, should epoch time be converted to date? defaults to TRUE}

\item{verbose}{logical, Whether to display messages}

\item{...}{Further arguments passed as query parameters. See [ps_params] for all possible parameters.}
}
\value{
tibble of comments
}
\description{
Search Pushshift.io for Reddit comments
}
\details{
Use [to_epoch] to convert a date to epoch time
}
\examples{
\dontrun{
# get the last 100 comments with the word 'cats'
search_comments(q = "cats", size = 100)
}
}
