% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/balance.R
\name{balance}
\alias{balance}
\title{Returns a summary of the balance for all bootstrap samples.}
\usage{
balance(psaboot, na.rm = TRUE, pool.fun = mean)
}
\arguments{
\item{psaboot}{results from `[PSAboot()]`.}

\item{na.rm}{should NAs be removed. NAs generally occur when there is insufficient
sample for a particular covariate or an unused level.}

\item{pool.fun}{a function specifying how the effect sizes across all covariates
should be combined. Possible values include `mean()` (default),
`q25()`, `q75()`, `median()`, `max()`, or 
any function that takes a vector of numeric values.}
}
\value{
a list with three elements:
\describe{
	\item{unadjusted}{named numeric vector with unadjusted effect size before
	                  adjustment for each covariate}
	\item{complete}{a matrix with adjusted effect size for each covariate (columns)
	                for each method (rows).}
	\item{pooled}{a matrix with mean adjusted effect size for all covariates for each
	              method (columns) and each bootstrap sample (rows).}
	\item{balances}{a list with an M x n covariates matrix for each method.}
}
}
\description{
This method provides some crude overall measures of balance.
}
\examples{
\donttest{
library(PSAboot)
data(pisa.psa.cols)
data(pisausa)
bm.usa <- PSAboot(Tr = as.integer(pisausa$PUBPRIV) - 1,
    Y = pisausa$Math,
    X = pisausa[,pisa.psa.cols],
    control.ratio = 5, M = 100, seed = 2112)
bm.usa.bal <- balance(bm.usa)

}
}
