% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdsn.R
\name{rdsn}
\alias{rdsn}
\title{DS Normal Distribution}
\usage{
rdsn(n, a, b, c, teta)
}
\arguments{
\item{n}{positive number of observations}

\item{a}{non-negative multipurpose parameter and a+b>0}

\item{b}{non-negative multipurpose parameter and a+b>0}

\item{c}{real multipurpose parameter}

\item{teta}{real position parameter}
}
\value{
The function returns random generator values for the DS normal distribution
}
\description{
Density, distribution function, quantile function and random generation
for the DS normal distribution with parameters a, b, c and d.
}
\details{
Probability density function in Latex
see formula (5) in the paper
Cumulative distribution function in Latex
see formula (6)
Quantile function
see formulas (8,9,10)
Random number generator
see Theorem (5)
}
\examples{
ddsn(-0.5,2,2,2,0)
pdsn(-0.5,2,2,2,0)
qdsn(0.5,2,2,2,0)
rdsn(10,2,2,2,0)

}
\references{
{Sulewski P. (2021). \emph{DS Normal Distribution: properties and applications.} Lobachevskii Journal of Mathematics 42(12), 2980-2999.}
}
\author{
Piotr Sulewski, \email{piotr.sulewski@upsl.edu.pl}, Pomeranian UNiwersity in Slupsk.
}
