% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Lms2.pvalue.R
\name{Lms2.pvalue}
\alias{Lms2.pvalue}
\title{Logarithmic Minimum Test for Independence in Two-Way Contingency Table}
\usage{
Lms2.pvalue(stat, nr, nc, n, B = 10000)
}
\arguments{
\item{stat}{a logarithmic minimum statistic value}

\item{nr}{a number of rows}

\item{nc}{a number of columns}

\item{n}{a sample size}

\item{B}{an integer specifying the number of replicates used in the Monte Carlo test (optional)}
}
\value{
The function returns the p-value of the logarithmic minimum test.
}
\description{
Calculates the p-value of the logarithmic minimum test.
}
\details{
The p-value of  the logarithmic minimum test for independence in r x c contingency table,
data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABIAAAASCAYAAABWzo5XAAAAWElEQVR42mNgGPTAxsZmJsVqQApgmGw1yApwKcQiT7phRBuCzzCSDSHGMKINIeDNmWQlA2IigKJwIssQkHdINgxfmBBtGDEBS3KCxBc7pMQgMYE5c/AXPwAwSX4lV3pTWwAAAABJRU5ErkJggg==
}
\examples{
Lms2.pvalue(Lms2.stat(table1), 2, 2, 40, B = 1e3)
Lms2.pvalue(Lms2.stat(table2), 2, 3, 60, B = 1e2)

}
\references{
{Sulewski, P. (2019). \emph{The LMS for Testing Independence in Two-way Contingency Tables.} Biometrical Letters 56(1), 17-43}
}
\author{
Piotr Sulewski, \email{piotr.sulewski@apsl.edu.pl}, Pomeranian University in Slupsk.
}
