% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Lms2.test.R
\name{Lms2.test}
\alias{Lms2.test}
\title{Logarithmic Minimum Test for Independence in Two-Way Contingency Table}
\usage{
Lms2.test(nij, B = 10000)
}
\arguments{
\item{nij}{a numeric matrix with non-negative values of the two-way contingency table cells}

\item{B}{an integer specifying the number of replicates used in the Monte Carlo test (optional)}
}
\value{
The function returns values of the test statistic and p-value of the logarithmic minimum test.
}
\description{
Calculates the test statistic and p-value of the logarithmic minimum test.
}
\details{
The test statistic and p-value of he logarithmic minimum test for independence in r x c contingency table,
}
\examples{
\donttest{Lms2.test(GenTab2(matrix(1/6, nrow = 2, ncol = 3), 50), B = 1e2)}
\donttest{Lms2.test(table2, B = 1e3)}

}
\references{
{Sulewski, P. (2019). \emph{The LMS for Testing Independence in Two-way Contingency Tables.} Biometrical Letters 56(1), 17-43}
}
\author{
Piotr Sulewski, \email{piotr.sulewski@apsl.edu.pl}, Pomeranian University in Slupsk.
}
