% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Mod3.cv.R
\name{Mod3.cv}
\alias{Mod3.cv}
\title{Modular test for independence in three-way contingency table}
\usage{
Mod3.cv(nr, nc, nt, n, alfa, B = 10000)
}
\arguments{
\item{nr}{a number of rows}

\item{nc}{a number of columns}

\item{nt}{a number of tubes}

\item{n}{a sample size}

\item{alfa}{a significance level}

\item{B}{an integer specifying the number of replicates used in the Monte Carlo test (optional)}
}
\value{
The function returns the critical value of the modular test.
}
\description{
Calculates the critical value of the modular test for independence in three-way contingency table
(see Sulewski P. (2018)).
}
\details{
The Critical value of the modular test for independence in r x c x t contingency table,
}
\examples{
Mod3.cv(2, 2, 2, 80, 0.05, B = 1e2)
\donttest{Mod3.cv(2, 2, 2, 80, 0.1, B = 1e3)}

}
\references{
{Sulewski, P. (2018). \emph{Power Analysis Of Independence Testing for the Three-Way Con-tingency Tables of Small Sizes.} Journal of Applied Statistics 45(13), 2481-2498}
}
\author{
Piotr Sulewski, \email{piotr.sulewski@apsl.edu.pl}, Pomeranian University in Slupsk.
}
