% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Mod3.stat.R
\name{Mod3.stat}
\alias{Mod3.stat}
\title{Modular test for independence in three-way contingency table}
\usage{
Mod3.stat(nijt)
}
\arguments{
\item{nijt}{a numeric matrix with non-negative values of the three-way contingency table cells}
}
\value{
The function returns the value of the modular test statistic.
}
\description{
Calculates the statistic of the modular test for independence in three-way contingency table
(see Sulewski P. (2018)).
}
\details{
The statistic of the modular test for independence in r x c x t contingency table,
see formula (6) in the article.
}
\examples{
Mod3.stat(GenTab3(array(0.125, dim = c(2, 2, 2)), 100))
Mod3.stat(table4)

}
\references{
{Sulewski, P. (2018). \emph{Power Analysis Of Independence Testing for the Three-Way Con-tingency Tables of Small Sizes.} Journal of Applied Statistics 45(13), 2481-2498}
}
\author{
Piotr Sulewski, \email{piotr.sulewski@apsl.edu.pl}, Pomeranian University in Slupsk.
}
