% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Mod4.cv.R
\name{Mod4.cv}
\alias{Mod4.cv}
\title{Modular test for independence in four-way contingency table}
\usage{
Mod4.cv(nr, nc, nt, nu, n, alfa, B = 10000)
}
\arguments{
\item{nr}{a number of rows}

\item{nc}{a number of columns}

\item{nt}{a number of tubes}

\item{nu}{a number of tubes}

\item{n}{a sample size}

\item{alfa}{a significance level}

\item{B}{an integer specifying the number of replicates used in the Monte Carlo test (optional)}
}
\value{
The function returns the critical value of the modular test.
}
\description{
Calculates the critical value of the modular test for independence in four-way contingency table
}
\details{
The Critical value of the Logarithmic minimum test for independence in r x c x t contingency table,
}
\examples{

Mod4.cv(2, 2, 2, 2, 160, 0.05, B = 1e2)
\donttest{Mod4.cv(2, 2, 2, 2, 160, 0.1, B = 1e3)}

}
\references{
Extension of the information contained in {Sulewski, P. (2018). \emph{Power Analysis Of Independence Testing for the Three-Way Con-tingency Tables of Small Sizes.} Journal of Applied Statistics 45(13), 2481-2498}
}
\author{
Piotr Sulewski, \email{piotr.sulewski@apsl.edu.pl}, Pomeranian University in Slupsk.
}
