% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Mod4.pvalue.R
\name{Mod4.pvalue}
\alias{Mod4.pvalue}
\title{MOdular test for independence in four-way contingency table}
\usage{
Mod4.pvalue(stat, nr, nc, nt, nu, n, B = 10000)
}
\arguments{
\item{stat}{a Logarithmic minimum statistic value}

\item{nr}{a number of rows}

\item{nc}{a number of columns}

\item{nt}{a number of tubes}

\item{nu}{a number of}

\item{n}{a sample size}

\item{B}{an integer specifying the number of replicates used in the Monte Carlo test (optional)}
}
\value{
The function returns the p-value of the modular test.
}
\description{
Calculates the p-value of the modular test for independence in four-way contingency table
}
\details{
The Critical value of the modular test for independence in r x c x t x u contingency table,
}
\examples{
Mod4.pvalue(Mod4.stat(table6), 2, 2, 2, 2, 160, B = 1e2)
Mod4.pvalue(Mod4.stat(table6), 2, 2, 2, 2, 160, B = 1e3)

}
\references{
Extension of the information contained in {Sulewski, P. (2018). \emph{Power Analysis Of Independence Testing for the Three-Way Con-tingency Tables of Small Sizes.} Journal of Applied Statistics 45(13), 2481-2498}
}
\author{
Piotr Sulewski, \email{piotr.sulewski@apsl.edu.pl}, Pomeranian University in Slupsk.
}
