#' PSRICalcSM: Plant Stress Response Index Calculator - Softmax Method
#'
#' Implements the softmax aggregation method for calculating Plant Stress
#' Response Index (PSRI) from time-series germination data. This package
#' provides a zero-robust alternative to the geometric mean PSRI implemented
#' in the \code{PSRICalc} package.
#'
#' @section Main function:
#' \code{\link{compute_psri_sm}} computes the softmax PSRI from germination
#' count data across multiple timepoints, with optional radicle vigor
#' integration.
#'
#' @section Component functions:
#' \itemize{
#'   \item \code{\link{compute_msg}} - Maximum Stress-adjusted Germination
#'   \item \code{\link{compute_mrg}} - Maximum Rate of Germination
#'   \item \code{\link{compute_cmtg}} - Complementary Mean Time to Germination
#'   \item \code{\link{compute_rvs}} - Radicle Vigor Score (continuous 0-1)
#'   \item \code{\link{softmax_weights}} - Softmax weight calculation
#' }
#'
#' @section Temperature calibration:
#' \code{\link{calibrate_temperature}} provides perplexity-based temperature
#' parameter selection for the softmax aggregation.
#'
#' @section Comparison with PSRICalc (geometric method):
#' The geometric PSRI collapses to zero when any component equals zero:
#' \deqn{PSRI_{GM} = (\prod C_i)^{1/3} \times RVF}
#' The softmax PSRI handles zeros through adaptive reweighting:
#' \deqn{PSRI_{SM} = \sum W_i \cdot C_i}
#' where \eqn{W_i = \exp(C_i / T) / \sum \exp(C_j / T)}.
#'
#' @references
#' Walne, C.H., Gaudin, A., Henry, W.B., and Reddy, K.R. (2020).
#' In vitro seed germination response of corn hybrids to osmotic stress
#' conditions. \emph{Agrosystems, Geosciences & Environment}, 3(1), e20087.
#' \doi{10.1002/agg2.20087}
#'
#' Feiss, R.A. (2025). PSRICalc: Plant Stress Response Index Calculator
#' (R package version 1.0.0).
#' \url{https://CRAN.R-project.org/package=PSRICalc}
#'
#' @section Human-AI Development Transparency:
#' Development followed an iterative human-machine collaboration. All
#' algorithmic design, statistical methodologies, and biological validation
#' logic were conceptualized, tested, and iteratively refined by the human
#' author. AI systems (Anthropic Claude and OpenAI GPT) served as coding
#' assistants and analytical sounding boards under continuous human direction.
#' AI systems did not independently originate algorithms, statistical
#' approaches, or scientific methodologies.
#'
#' @docType package
#' @name PSRICalcSM-package
#' @aliases PSRICalcSM
"_PACKAGE"
