\name{PSRICalcSM-package}
\alias{PSRICalcSM-package}
\alias{PSRICalcSM}
\docType{package}
\title{Plant Stress Response Index Calculator - Softmax Method}
\description{
Implements the softmax aggregation method for calculating Plant Stress
Response Index (PSRI) from time-series germination data. Provides a
zero-robust alternative to the geometric mean PSRI in \pkg{PSRICalc}.
}
\details{
The main function is \code{\link{compute_psri_sm}}, which computes the
softmax PSRI from germination count data. Component functions
(\code{\link{compute_msg}}, \code{\link{compute_mrg}},
\code{\link{compute_cmtg}}, \code{\link{compute_rvs}}) are available
for modular analysis. Use \code{\link{calibrate_temperature}} for
data-driven temperature parameter selection.
}
\author{
Richard A. Feiss IV

Maintainer: Richard A. Feiss IV <feiss026@umn.edu>
}
\references{
Walne, C.H., Gaudin, A., Henry, W.B., and Reddy, K.R. (2020).
In vitro seed germination response of corn hybrids to osmotic stress
conditions. \emph{Agrosystems, Geosciences & Environment}, 3(1), e20087.
\doi{10.1002/agg2.20087}
}
\seealso{
\code{\link{compute_psri_sm}}, \code{\link{calibrate_temperature}}
}
