\name{compute_mrg}
\alias{compute_mrg}
\title{Compute Maximum Rate of Germination (MRG)}
\description{
Calculates MRG as the scaled average germination rate across consecutive
observation intervals.
}
\usage{
compute_mrg(germination_counts, timepoints, total_seeds)
}
\arguments{
  \item{germination_counts}{Integer vector of cumulative germination counts
    at each timepoint.}
  \item{timepoints}{Numeric vector of observation times (e.g., days). Must
    be the same length as \code{germination_counts}.}
  \item{total_seeds}{Integer. Total number of seeds in the replicate.}
}
\value{
Numeric value >= 0 representing the scaled germination rate.
For a single timepoint, returns 0.1 (rate not computable).
}
\examples{
compute_mrg(c(5, 15, 20), timepoints = c(3, 5, 7), total_seeds = 25)
compute_mrg(c(10), timepoints = c(3), total_seeds = 25)
}
\seealso{\code{\link{compute_psri_sm}}}
