% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{makepseudo}
\alias{makepseudo}
\title{Nearest neighbor augmentatation based on ranks}
\usage{
makepseudo(N, n, k, a, alltrt)
}
\arguments{
\item{N}{total number of covariate values.}

\item{n}{vector of sample sizes from all treatments}

\item{k}{number of nearest neighbors}

\item{a}{number of treatment levels in the data}

\item{alltrt}{a matrix of dimension 3x\code{N}, whose first two rows are
Y and X, and the third row gives the rank of X values within the
same treatment level.}
}
\value{
A list containing the following:
        psudo: a 3-d array of the dimension (k, a, N) that stores the
               augmented observations based on k-nearest neighbor rule
               in Wang, Tolos and Wang (2010).
        index: a 3-d array of the dimension (k, a, N) that stores the
               index of which observation was used for augmentation.
}
\description{
The function makepseudo performs the nearest neighbor augmentation
based on the rank of covariate values according to the scheme discribed
on page 410-411 of Wang, Tolos and Wang (2010)
}
\examples{
 a=2; n=c(7,9); N=sum(n);  X=runif(N);
 trt=c(rep(1,n[1]), rep(2, n[2])); e=rnorm(N, 0, 0.1)
 Y=ifelse(trt==1, 4*(X-0.5)^2+e, 2*X+e)
 ranksuse=unlist(tapply(X, trt, rank) )
 alltrt=rbind(Y, X, ranksuse )
 aug=makepseudo(N,n, k=3, a, alltrt)

}
\references{
Haiyan Wang, Siti Tolos, and Suojin Wang (2010). A Distribution Free
 Nonparametric Test to Detect Dependence Between a Response Variable and
 Covariate in Presence of Heteroscedastic Treatment Effects.
 The Canadian Journal of Statistics. 38(3), 408433. Doi:10.1002/cjs.10068
}
