% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/C00-weighted-km.R
\name{summary.weightedKM}
\alias{summary.weightedKM}
\title{Summary Method for Weighted Kaplan-Meier Estimates}
\usage{
\method{summary}{weightedKM}(
  object,
  type = "Kaplan-Meier",
  conf_type = "log-log",
  conf_level = 0.95,
  print.digits = 3,
  print.rows = 10,
  ...
)
}
\arguments{
\item{object}{An object of class "weightedKM" from \code{weightedKM()}.}

\item{type}{Type of estimate to summarize: "Kaplan-Meier" (survival probabilities,
default) or "CR" (cumulative risk, aka. cumulative incidence = 1 - survival).}

\item{conf_type}{Type of confidence interval: "plain", "log", or
"log-log" (default). See \code{?plot.weightedKM} for details.}

\item{conf_level}{Confidence level for intervals. Default 0.95.}

\item{print.digits}{Number of decimal places for printed output. Default 3.}

\item{print.rows}{Number of rows to print for each treatment group. Default 10.}

\item{...}{Additional arguments (currently unused).}
}
\value{
A list with one element per treatment group. Each element is a matrix
  with columns:
  \itemize{
    \item \code{time}: Evaluation time points
    \item \code{estimate}: Survival probability or cumulative risk
    \item \code{se}: Standard error
    \item \code{CI_lower}: Lower confidence bound
    \item \code{CI_upper}: Upper confidence bound
  }
  The list is returned invisibly with full precision. Printed output is
  rounded to \code{print.digits} decimal places and shows first \code{print.rows}
  rows per group.
}
\description{
Generates summary tables of weighted Kaplan-Meier survival or cumulative risk
estimates with confidence intervals for each treatment group.
}
\details{
This method provides tabular summaries of weighted Kaplan-Meier estimates with
confidence intervals. It uses the same CI calculation methods as
\code{plot.weightedKM()}.

When \code{type = "CR"}, the function transforms survival estimates to
cumulative risk \eqn{1 - S} and calculates confidence intervals on that scale.

The returned list contains full-precision matrices that can be used for
further analysis. The printed output is rounded for readability.
}
