
##################################################################################################
#Library  PTwin    W: weight in grams, GA: gestational age in days, dichorionic: TRUE/FALSE
##################################################################################################

PTwins<-function(weight,week,day=3,dichorionic=TRUE){

if(length(weight)!=length(week) | length(weight)!=length(day) | length(week)!=length(day)){
	warning("The length of the arguments \"weight\", \"week\" and \"day\" must be the same")
}
if(any(week<18)){
	warning("The function is only applicable from 18th week")
}
if(any(week%%1!=0)){
	warning("The argument \"week\" must be an integer value or integer list")
}
if(any(day%%1!=0)){
	warning("The argument \"day\" must be an integer value or integer list")
}

P50Mono<-c(144.7938,149.0449,153.4208,157.9251,162.5614,167.3327,172.2418,177.2917,182.4855,187.8261,193.3163,198.9592,204.7576,210.7143,216.8323,223.1142,229.5629,236.1809,242.9710,249.9355,257.0770,264.3978,271.9001,279.5861,287.4577,295.5169,303.7654,312.2048,320.8364,329.6615,338.6811,347.8961,357.3071,366.9145,376.7184,386.7187,396.9151,407.3070,417.8933,428.6728,439.6441,450.8051,462.1535,473.6868,485.4028,497.3016,509.3839,521.6506,534.1024,546.7403,559.5651,572.5777,585.7789,599.1697,612.7511,626.5241,640.4896,654.6487,669.0026,683.5525,698.2995,713.2448,728.3900,743.7362,759.2850,775.0380,790.9967,807.1628,823.5381,840.1244,856.9237,873.9381,891.1697,908.6207,926.2935,944.1907,962.3148,980.6686,999.2549,1018.0757,1037.1288,1056.4109,1075.9182,1095.6465,1115.5914,1135.7482,1156.1116,1176.6761,1197.4358,1218.3845,1239.5154,1260.8215,1282.2954,1303.9291,1325.7144,1347.6425,1369.7044,1391.8905,1414.1908,1436.5950,1459.0922,1481.6711,1504.3201,1527.0271,1549.7795,1572.5642,1595.3680,1618.1771,1640.9771,1663.7534,1686.4910,1709.1745,1731.7881,1754.3154,1776.7400,1799.0479,1821.2367,1843.3073,1865.2613,1887.1007,1908.8282,1930.4468,1951.9601,1973.3724,1994.6884,2015.9133,2037.0528,2058.1132,2079.1014,2100.0247,2120.8908,2141.7082,2162.4858,2183.2329,2203.9595,2224.6760,2245.3934,2266.1231,2286.8770,2307.6678,2328.5084,2349.4123,2370.3938,2391.4673,2412.6480,2433.9516,2455.3945,2476.9933,2498.7656,2520.7264,2542.8803,2565.2288,2587.7737,2610.5168,2633.4598)
VarMono<-c(0.01693291,0.01681010,0.01670024,0.01660235,0.01651549,0.01643878,0.01637136,0.01631244,0.01626125,0.01621706,0.01617920,0.01614702,0.01611991,0.01609728,0.01607861,0.01606338,0.01605112,0.01604137,0.01603373,0.01602781,0.01602323,0.01601968,0.01601684,0.01601442,0.01601217,0.01600984,0.01600721,0.01600410,0.01600031,0.01599570,0.01599013,0.01598345,0.01597558,0.01596641,0.01595588,0.01594390,0.01593044,0.01591544,0.01589890,0.01588078,0.01586108,0.01583981,0.01581697,0.01579259,0.01576668,0.01573929,0.01571046,0.01568023,0.01564865,0.01561577,0.01558167,0.01554640,0.01551002,0.01547262,0.01543425,0.01539500,0.01535494,0.01531415,0.01527270,0.01523067,0.01518814,0.01514519,0.01510190,0.01505833,0.01501457,0.01497069,0.01492675,0.01488285,0.01483903,0.01479537,0.01475193,0.01470878,0.01466597,0.01462356,0.01458161,0.01454016,0.01449927,0.01445899,0.01441934,0.01438039,0.01434216,0.01430468,0.01426800,0.01423215,0.01419714,0.01416301,0.01412978,0.01409746,0.01406609,0.01403568,0.01400624,0.01397780,0.01395035,0.01392393,0.01389854,0.01387419,0.01385090,0.01382869,0.01380757,0.01378755,0.01376865,0.01375091,0.01373432,0.01371893,0.01370477,0.01369186,0.01368025,0.01366997,0.01366108,0.01365363,0.01364768,0.01364331,0.01364058,0.01363958,0.01364041,0.01364317,0.01364798,0.01365495,0.01366423,0.01367597,0.01369034,0.01370750,0.01372765,0.01375100,0.01377778,0.01380823,0.01384261,0.01388120,0.01392429,0.01397222,0.01402532,0.01408396,0.01414853,0.01421945,0.01429715,0.01438211,0.01447482,0.01457580,0.01468561,0.01480484,0.01493410,0.01507404,0.01522536,0.01538878,0.01556504,0.01575496,0.01595937,0.01617914,0.01641519,0.01666850,0.01694006,0.01723092,0.01754220,0.01787503,0.01823061)
P50Bi<-c(161.0895,165.2386,169.4945,173.8600,178.3380,182.9313,187.6429,192.4758,197.4332,202.5184,207.7344,213.0849,218.5731,224.2027,229.9773,235.9006,241.9765,248.2089,254.6018,261.1593,267.8858,274.7855,281.8629,289.1226,296.5693,304.2077,312.0429,320.0800,328.3240,336.7799,345.4508,354.3394,363.4481,372.7791,382.3345,392.1163,402.1260,412.3652,422.8349,433.5361,444.4695,455.6353,467.0336,478.6639,490.5257,502.6177,514.9385,527.4862,540.2584,553.2522,566.4644,579.8911,593.5280,607.3702,621.4123,635.6482,650.0712,664.6742,679.4507,694.3992,709.5199,724.8129,740.2785,755.9169,771.7286,787.7142,803.8742,820.2096,836.7211,853.4099,870.2770,887.3240,904.5521,921.9632,939.5590,957.3414,975.3128,993.4754,1011.8318,1030.3847,1049.1372,1068.0925,1087.2539,1106.6252,1126.2101,1146.0129,1166.0380,1186.2901,1206.7740,1227.4950,1248.4568,1269.6559,1291.0864,1312.7421,1334.6163,1356.7019,1378.9911,1401.4759,1424.1475,1446.9967,1470.0138,1493.1887,1516.5104,1539.9678,1563.5488,1587.2412,1611.0318,1634.9071,1658.8530,1682.8548,1706.8973,1730.9646,1755.0403,1779.1075,1803.1488,1827.1460,1851.0806,1874.9336,1898.6852,1922.3154,1945.8035,1969.1284,1992.2687,2015.2023,2037.9068,2060.3594,2082.5370,2104.4160,2125.9727,2147.1829,2168.0222,2188.4721,2208.5379,2228.2321,2247.5682,2266.5606,2285.2252,2303.5785,2321.6381,2339.4226,2356.9516,2374.2454,2391.3254,2408.2138,2424.9335,2441.5083,2457.9630,2474.3230,2490.6144,2506.8643,2523.1003,2539.3511,2555.6459,2572.0146,2588.4831)
VarBi<-c(0.02336101,0.02236904,0.02144637,0.02058935,0.01979449,0.01905844,0.01837795,0.01774993,0.01717139,0.01663948,0.01615146,0.01570470,0.01529670,0.01492505,0.01458744,0.01428170,0.01400569,0.01375747,0.01353514,0.01333684,0.01316087,0.01300559,0.01286946,0.01275100,0.01264881,0.01256159,0.01248808,0.01242711,0.01237758,0.01233845,0.01230874,0.01228754,0.01227400,0.01226730,0.01226671,0.01227154,0.01228114,0.01229492,0.01231234,0.01233288,0.01235609,0.01238154,0.01240885,0.01243768,0.01246771,0.01249866,0.01253028,0.01256236,0.01259470,0.01262713,0.01265953,0.01269176,0.01272374,0.01275538,0.01278663,0.01281745,0.01284782,0.01287772,0.01290716,0.01293616,0.01296473,0.01299293,0.01302079,0.01304836,0.01307572,0.01310291,0.01313002,0.01315711,0.01318426,0.01321156,0.01323907,0.01326689,0.01329509,0.01332376,0.01335296,0.01338278,0.01341329,0.01344456,0.01347666,0.01350965,0.01354358,0.01357852,0.01361451,0.01365159,0.01368981,0.01372918,0.01376975,0.01381152,0.01385451,0.01389873,0.01394418,0.01399085,0.01403874,0.01408782,0.01413807,0.01418946,0.01424196,0.01429552,0.01435011,0.01440568,0.01446216,0.01451951,0.01457766,0.01463655,0.01469612,0.01475630,0.01481702,0.01487821,0.01493981,0.01500174,0.01506396,0.01512639,0.01518897,0.01525165,0.01531439,0.01537714,0.01543987,0.01550255,0.01556516,0.01562771,0.01569019,0.01575263,0.01581505,0.01587752,0.01594009,0.01600286,0.01606591,0.01612939,0.01619344,0.01625823,0.01632396,0.01639086,0.01645917,0.01652920,0.01660125,0.01667568,0.01675287,0.01683326,0.01691730,0.01700551,0.01709844,0.01719668,0.01730088,0.01741173,0.01752998,0.01765643,0.01779193,0.01793740,0.01809382,0.01826223,0.01844372,0.01863947,0.01885072,0.01907878,0.01932505)

DT<-data.frame(seq(112,266),P50Mono,VarMono,P50Bi,VarBi)
names(DT)[1]<-c("GA")
percentile<-c()

percentile_function<-function(x){
	GA<-week[x]*7+day[x]
	W<-weight[x]
	if(dichorionic[x]==FALSE)
		percentile<-c(percentile,round(100*pnorm((log(W)-log(DT[which(DT[,1]==GA),2]))/sqrt(DT[which(DT[,1]==GA),3])),digits=1))
	else if(dichorionic[x]==TRUE)
		percentile<-c(percentile,round(100*pnorm((log(W)-log(DT[which(DT[,1]==GA),4]))/sqrt(DT[which(DT[,1]==GA),5])),digits=1))
	percentile
}
percentile_output<-sapply(1:length(weight), percentile_function)
list(Percentile=percentile_output,weight=weight, GA=round(week+day/7,digits=1) )
}

