% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aksummary.nl.R
\name{aksummary.nl}
\alias{aksummary.nl}
\title{Non-Linear Adsorption Kinetic Models Summary}
\usage{
aksummary.nl(t, qt, qe, n, sort.by)
}
\arguments{
\item{t}{the numerical value for contact time}

\item{qt}{the numerical value for the amount adsorbed at time t}

\item{qe}{the numerical value for the amount adsorbed at equilibrium}

\item{n}{the numerical value for the richie's equation order of reaction}

\item{sort.by}{the name of the statistical error parameter in which the models are sorted in either increasing or decreasing order. The only accepted arguments are "RMSE" for Relative Mean Square Error, 'MAE' for Mean Absolute Error, 'MSE' for Mean Squared Error, 'RAE' for Relative Absolute Error, 'AIC' for Akaike Information Criterion, 'BIC' for Bayesian Information Criterion, 'R2' for Coefficient of Determination, and 'SE' for Standard Error Estimate. This argument is case-sensitive, and failure to input the correct value will yield a summary of models in alphabetical order.}
}
\value{
the summarized error and parameter values from non-linear adsorption kinetic models.
}
\description{
Summarized results of parameter and error values collected from non-linear adsorption kinetic models, namely: Avrami, Elovich, Fractional Power, Pseudo-First-Order, Pseudo-nth-Order, Pseudo-Second-Order, and Richie's Equation.
}
\examples{
\donttest{
t <- c(15,30,45,60,75,90,105,120)
qt <- c(3.718,3.888,4.102,4.274,4.402,4.444,4.488,4.616)
qe <- 4.68
aksummary.nl(t,qt,qe,n=NULL,"SE")}
}
\author{
Jeff Ryan S. Magalong

Joshua Z. DelaCruz

Jeann M. Bumatay

Chester C. Deocaris
}
