% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crank.R
\name{crank}
\alias{crank}
\title{Non-Linear Crank Diffusion Model}
\usage{
crank(t, qt, qinf)
}
\arguments{
\item{t}{the numerical value for contact time}

\item{qt}{the numerical value for the amount adsorbed at time t}

\item{qinf}{the numerical value for the amount adsorbed at infinite time. If this argument is not defined, it will be estimated.}
}
\value{
the non-linear regression and the parameter estimation for the Crank Adsorption Kinetic Model
}
\description{
The Crank Diffusion Model is an equation for homogeneous adsorbate diffusion in a sphere-shaped adsorbent with constant surface diffusivity throughout the particle. It's an exact solution for the "infinite bath" case, in which the sphere starts out empty and the solute concentration at the surface remains constant. Due to the constant surface concentration, external film resistance may be ignored (Qiu, Lv, Pan, Zhang, Zhang, and Zhang, 2009).
}
\examples{
\donttest{
t <- c(0,15,30,45,60,75,90,105,120)
qt <- c(0.000,3.718,3.888,4.102,4.274,4.402,4.444,4.488,4.616)
qinf <- 4.68
crank(t,qt,qinf)}
}
\references{
Crank, J. (1979) <ISBN, 0198534116, 9780198534112>The mathematics of diffusion. Oxford university press.

Qiu, H., Lv, L., Pan, B. C., Zhang, Q. J., Zhang, W. M., &; Zhang, Q. X. (2009) <doi:10.1631/jzus.A0820524> Critical review in adsorption kinetic models. In Journal of Zhejiang University: Science A (Vol. 10, Issue 5, pp. 716-724).
}
\author{
Jeff Ryan S. Magalong

Joshua Z. DelaCruz

Jeann M. Bumatay

Chester C. Deocaris
}
