% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GABMSI.R
\name{GABMSI}
\alias{GABMSI}
\title{Guggenheim-Anderson-de Boer(GAB) Moisture Sorption Isotherm}
\usage{
GABMSI(WaterAct, AdsorpM, DesorpM)
}
\arguments{
\item{WaterAct}{the numerical value of Water Activity, which ranges from 0 to 1.}

\item{AdsorpM}{the numerical value of the Moisture content of the Adsorption curve, which ranges from 0 to 1.}

\item{DesorpM}{the numerical value of the Moisture content of the Desorption curve, which ranges from 0 to 1.}
}
\value{
the nonlinear regression, parameters, and graphical visualization for the Guggenheim-Anderson-de Boer(GAB) Moisture Sorption Isotherm model.
}
\description{
GAB model is a multimolecular, localized and homogeneous adsorption model, is one of the most versatile models considering multilayer adsorption at high water activity values.
}
\examples{
WaterAct <- c(0.1145,0.2274,0.3265,0.4291,0.6342,0.7385,0.8274,0.9573)
AdsorpM <- c(0.0234, 0.0366, 0.0496, 0.0648, 0.0887, 0.1096, 0.1343, 0.1938)
DesorpM <- c(0.0459, 0.0637, 0.0794, 0.0884, 0.1158, 0.1298,0.1500, 0.1938)
GABMSI(WaterAct, AdsorpM, DesorpM)
}
\references{
Aviara, N. A. (2020) <doi:10.5772/intechopen.87996> Moisture Sorption Isotherms and Isotherm Model Performance Evaluation for Food and Agricultural Products. In Sorption in 2020s. IntechOpen.

Aviara, N. A., et al. (2016). Effect of Temperature and Moisture Sorption Hysteresis on Monolayer Moisture Content of Selected Crops Determined Using BET and GAB Models. 37Th Annual Conference and Annual General Meeting-"Minna 2016," October.

Maroulis, Z. B., et al. (1988) <doi:10.1016/0260-8774(88)90069-6> Application of the GAB model to the moisture sorption isotherms for dried fruits. Journal of Food Engineering, 7(1), 63-78.

Prasantha, B. D. R. (2018). Prediction of Moisture Adsorption Characteristics of Dehydrated Fruits Using the GAB. Ann Agric Crop Sci, 3(1), 1-4.
}
\author{
Benz L. Rivera

John Carlo F. Panganiban

Kim M. Villacorte

Chester C. Deocaris
}
