% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HalseyMSI.R
\name{HalseyMSI}
\alias{HalseyMSI}
\title{Halsey Moisture Sorption Isotherm}
\usage{
HalseyMSI(WaterAct, AdsorpM, DesorpM)
}
\arguments{
\item{WaterAct}{the numerical value of Water Activity, which ranges from 0 to 1.}

\item{AdsorpM}{the numerical value of the Moisture content of the Adsorption curve, which ranges from 0 to 1.}

\item{DesorpM}{the numerical value of the Moisture content of the Desorption curve, which ranges from 0 to 1.}
}
\value{
the nonlinear regression, parameters, and graphical visualization for the Halsey Moisture Sorption Isotherm model.
}
\description{
Halsey Isotherm is a 2-parameter model which expresses condensation of multilayers at proportionally large distances from the surface considering the assumption that a molecule's potential energy is inversely proportional to the nth power of its distance from the surface.
}
\examples{
WaterAct <- c(0.1145,0.2274,0.3265,0.4291,0.6342,0.7385,0.8274,0.9573)
AdsorpM <- c(0.0234, 0.0366, 0.0496, 0.0648, 0.0887, 0.1096, 0.1343, 0.1938)
DesorpM <- c(0.0459, 0.0637, 0.0794, 0.0884, 0.1158, 0.1298,0.1500, 0.1938)
HalseyMSI(WaterAct, AdsorpM, DesorpM)
}
\references{
Halsey, G. (1948) <doi:10.1063/1.1746689> Physical adsorption on non-uniform surfaces. The Journal of Chemical Physics, 16(10), 931-937.
}
\author{
Benz L. Rivera

John Carlo F. Panganiban

Kim M. Villacorte

Chester C. Deocaris
}
