% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HendersonMSI.R
\name{HendersonMSI}
\alias{HendersonMSI}
\title{Henderson Moisture Sorption Isotherm}
\usage{
HendersonMSI(WaterAct, AdsorpM, DesorpM)
}
\arguments{
\item{WaterAct}{the numerical value of Water Activity, which ranges from 0 to 1.}

\item{AdsorpM}{the numerical value of the Moisture content of the Adsorption curve, which ranges from 0 to 1.}

\item{DesorpM}{the numerical value of the Moisture content of the Desorption curve, which ranges from 0 to 1.}
}
\value{
the nonlinear regression, parameters, and graphical visualization for the Henderson Moisture Sorption Isotherm model.
}
\description{
Henderson Isotherm is an empirical two-parameter equation for moisture adsorption of food products, useful in predicting moisture content for different water activity levels.
}
\examples{
WaterAct <- c(0.1145,0.2274,0.3265,0.4291,0.6342,0.7385,0.8274,0.9573)
AdsorpM <- c(0.0234, 0.0366, 0.0496, 0.0648, 0.0887, 0.1096, 0.1343, 0.1938)
DesorpM <- c(0.0459, 0.0637, 0.0794, 0.0884, 0.1158, 0.1298,0.1500, 0.1938)
HendersonMSI(WaterAct, AdsorpM, DesorpM)
}
\references{
Stencl, J. (2004) <doi:10.1260/0263617042863039> Moisture Sorption Isotherms of Whey Powder Spray in the 10-40C Temperature Range. Adsorption Science & Technology, 22(5), 377-384.
}
\author{
Benz L. Rivera

John Carlo F. Panganiban

Kim M. Villacorte

Chester C. Deocaris
}
