% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModChenMSI.R
\name{ModChenMSI}
\alias{ModChenMSI}
\title{Modified Chen Moisture Sorption Isotherm}
\usage{
ModChenMSI(WaterAct, AdsorpM, DesorpM)
}
\arguments{
\item{WaterAct}{the numerical value of Water Activity, which ranges from 0 to 1.}

\item{AdsorpM}{the numerical value of the Moisture content of the Adsorption curve, which ranges from 0 to 1.}

\item{DesorpM}{the numerical value of the Moisture content of the Desorption curve, which ranges from 0 to 1.}
}
\value{
the nonlinear regression, parameters, and graphical visualization for the Modified Chen  Moisture Sorption Isotherm model.
}
\description{
Modified Chen is 2-parameter model related to the drying principle. It is restricted to situations where diffusion is the primary mode of mass transport and is focused on the steady state of the drying equation.
}
\examples{
WaterAct <- c(0.1145,0.2274,0.3265,0.4291,0.6342,0.7385,0.8274,0.9573)
AdsorpM <- c(0.0234, 0.0366, 0.0496, 0.0648, 0.0887, 0.1096, 0.1343, 0.1938)
DesorpM <- c(0.0459, 0.0637, 0.0794, 0.0884, 0.1158, 0.1298,0.1500, 0.1938)
ModChenMSI(WaterAct, AdsorpM, DesorpM)
}
\references{
Chen, C. (2019) <doi:10.3390/foods8060191> Validation of the Component Model for Prediction of Moisture Sorption Isotherms of Two Herbs and other Products. Foods, 8(6), 191.

Chen, C. S. (1971) <doi:10.13031/2013.38421> Equilibrium Moisture Curves for Biological Materials. Transactions of the ASAE, 14(5), 0924-0926.

Chen, C. S. & Clayton, J. T. (1971) <doi:10.13031/2013.38422> The Effect Of Temperature On Sorption Isotherms Of Biological Materials. Transactions of the ASAE, 14(5), 0927-0929.
}
\author{
Benz L. Rivera

John Carlo F. Panganiban

Kim M. Villacorte

Chester C. Deocaris
}
