#' @title Population by single year age, sex and rural/urban
#' @name   TABLE_04
#' @docType data
#' @keywords datasets
#' @usage data(TABLE_04)
#' @description \code{TABLE_04} Population by single year age, sex and rural/urban
#' @format A \code{data.table} and  \code{data.frame}.
#' \describe{
#'   \item{\code{PROVINCE}}{PROVINCE}
#'   \item{\code{DISTRICT}}{DISTRICT}
#'   \item{\code{SEX_AGE_GROUP_IN_YEARS}}{SEX AGE GROUP IN YEARS}
#'   \item{\code{ALL_SEXES_OVERALL}}{ALL SEXES OVERALL}
#'   \item{\code{MALE_OVERALL}}{MALE OVERALL}
#'   \item{\code{FEMALE_OVERALL}}{FEMALE OVERALL}
#'   \item{\code{TRANSGENDER_OVERALL}}{TRANSGENDER OVERALL}
#'   \item{\code{ALL_SEXES_RURAL}}{ALL SEXES RURAL}
#'   \item{\code{MALE_RURAL}}{MALE RURAL}
#'   \item{\code{FEMALE_RURAL}}{FEMALE RURAL}
#'   \item{\code{TRANSGENDER_RURAL}}{TRANSGENDER RURAL}
#'   \item{\code{ALL_SEXES_URBAN}}{ALL SEXES URBAN}
#'   \item{\code{MALE_URBAN}}{MALE URBAN}
#'   \item{\code{FEMALE_URBAN}}{FEMALE URBAN}
#'   \item{\code{TRANSGENDER_URBAN}}{TRANSGENDER URBAN}
#'        }
#'
#' @author Muhammad Yaseen (\email{myaseen208@@gmail.com})
#'
#' @references \enumerate{
#' \item Pakistan Population Census 2023 (\url{https://www.pbs.gov.pk/}).
#'  }
#' 
#' @seealso
#'    \code{\link{PakPC2023PakDiv}}
#'  , \code{\link{PakPC2023PakDist}}
#'
#' @import DT htmltools
#' 
#' @examples
#' data(TABLE_04)
NULL
