% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{write_enrich_results_xlsx}
\alias{write_enrich_results_xlsx}
\title{Export Enrichment Results to Excel}
\usage{
write_enrich_results_xlsx(results, file = "enrich_results.xlsx")
}
\arguments{
\item{results}{A named list of data.frames (e.g., output from `pathway_vote`).}

\item{file}{Character. Output file path (e.g., "enrich_results.xlsx").}
}
\value{
Invisible. The path to the saved file.
}
\description{
Exports the results from `pathway_vote` to a multi-sheet Excel file.
Validates that the input is a list, checks for the `openxlsx` package, and handles sheet naming
to comply with Excel limitations.
}
\examples{
\dontrun{
# Assuming `res` is the output from pathway_vote(...)
write_enrich_results_xlsx(res, "my_results.xlsx")
}

}
