# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

TruncNormal <- function(rho, c1) {
    .Call('_Phase12Compare_TruncNormal', PACKAGE = 'Phase12Compare', rho, c1)
}

MATMULT <- function(X, Y) {
    .Call('_Phase12Compare_MATMULT', PACKAGE = 'Phase12Compare', X, Y)
}

#'Generate binary bivariate data.
#'
#'Generates binary bivariate data from a 2x2 matrix of probabilities.
#'@param PVEC Contains TRUE pi00,pi10, pi01, pi11 for each dose
#'@importFrom Rcpp evalCpp
#'@useDynLib Phase12Compare
#'@return Binary bivariate random variate (YE,YT).
#'@export
GETBIN <- function(PVEC) {
    .Call('_Phase12Compare_GETBIN', PACKAGE = 'Phase12Compare', PVEC)
}

#'Obtains optimal dose level.
#'
#'Gives the optimal dose level to assign the next patient cohort to based on the vector of optimality function values for each dose level (desirability or utility based) and the doses tried throughout the trial.
#'@param Desire Vector of optimality function values for each dose level.
#'@param DoseTried Binary vector containing 1 for doses that have been tried during the trial and 0 otherwise.
#'@importFrom Rcpp evalCpp
#'@useDynLib Phase12Compare
#'@return Optimal dose level to assign the next patient cohort.
#'@export
ReturnOpt <- function(Desire, DoseTried) {
    .Call('_Phase12Compare_ReturnOpt', PACKAGE = 'Phase12Compare', Desire, DoseTried)
}

#'Returns the desireability value of a dose.
#'
#'Takes estimated posterior mean efficacy and toxicity values and returns the posterior mean desireability score for a given tradeoff contour.
#'@param PE True or estimated probability of efficacy.
#'@param PT True of estimated probability of toxicity.
#'@param Contour Vector containing 4 entries used to make the desireability function. Contour(1) contains a desired toxicity probability given efficacy, Countour(2) contains a desired efficacy probability given toxicity, and (Contour(3),Contour(4)) is an equally desireable pair of efficacy and toxicity probabilities that are non zero or one.
#'@importFrom Rcpp evalCpp
#'@useDynLib Phase12Compare
#'@return Computes the real-valued desireability for an estimated (PE, PT) pair and elicited co
#'@examples
#'PE=.6
#'PT=.2
#'##Contour values
#'Contour=c(.35,.7,.8,.6)
#'GetDesire(PE,PT,Contour)
#'@export
GetDesire <- function(PE, PT, Contour) {
    .Call('_Phase12Compare_GetDesire', PACKAGE = 'Phase12Compare', PE, PT, Contour)
}

#'Simulates utility based Efftox trials
#'
#'Simulates utility based Efftox trials
#'@param DoseStart Dose level to START the EFF-Tox Trial
#'@param Dose Vector of Doses considered in the trial
#'@param Hypermeans 6 vector of prior means
#'@param Hypervars 6 vector of prior standard deviations
#'@param UT 2x2 matrix of utilities corresponding to the four binary bivariate (toxicity, efficacy) events.
#'@param PiLim 2 vector of acceptable limits
#'@param ProbLim 2 vector of cutoff for acceptabilities
#'@param cohort Cohort size
#'@param NET Maximum Sample size to run the EFFtox Trial, must be divisible by cohort
#'@param NF Minimum sample size to begin adaptive randomization, must be divisible by count
#'@param B Number of reps to perform in MCMC
#'@param nSims Number of Simulated trials to run.
#'@param PMAT Contains TRUE pi00,pi10, pi01, pi11 for each dose
#'@importFrom Rcpp evalCpp
#'@useDynLib Phase12Compare
#'@return Trial simulation results to be processed for operating characteristics summaries.
#'@export
RunAdaptiveEffToxTrialCORR <- function(DoseStart, Dose, Hypermeans, Hypervars, UT, PiLim, ProbLim, cohort, NET, NF, B, nSims, PMAT) {
    .Call('_Phase12Compare_RunAdaptiveEffToxTrialCORR', PACKAGE = 'Phase12Compare', DoseStart, Dose, Hypermeans, Hypervars, UT, PiLim, ProbLim, cohort, NET, NF, B, nSims, PMAT)
}

#'Simulates desirability based Efftox trials
#'
#'Simulates Efftox trials based on the desirability tradeoff contour.
#'@param DoseStart Dose level to START the EFF-Tox Trial
#'@param Dose Vector of Doses considered in the trial
#'@param Hypermeans 6 vector of prior means
#'@param Hypervars 6 vector of prior standard deviations
#'@param Contour 4 vector used to specify the tradeoff contour.
#'@param PiLim 2 vector of acceptable limits
#'@param ProbLim 2 vector of cutoff for acceptabilities
#'@param cohort Cohort size
#'@param NET Maximum Sample size to run the EFFtox Trial, must be divisible by cohort
#'@param NF Minimum sample size to begin adaptive randomization, must be divisible by count
#'@param B Number of reps to perform in MCMC
#'@param nSims Number of Simulated trials to run.
#'@param PMAT Contains TRUE pi00,pi10, pi01, pi11 for each dose
#'@importFrom Rcpp evalCpp
#'@useDynLib Phase12Compare
#'@return Trial simulation results to be processed for operating characteristics summaries.
#'@export
RunAdaptiveEffToxTrialCORRCONTOUR <- function(DoseStart, Dose, Hypermeans, Hypervars, Contour, PiLim, ProbLim, cohort, NET, NF, B, nSims, PMAT) {
    .Call('_Phase12Compare_RunAdaptiveEffToxTrialCORRCONTOUR', PACKAGE = 'Phase12Compare', DoseStart, Dose, Hypermeans, Hypervars, Contour, PiLim, ProbLim, cohort, NET, NF, B, nSims, PMAT)
}

#' Samples from the posterior of the utility based phase12 model.
#'
#' Takes arguments of data, hypermens and hypervariance vectors and returns a list of posterior samples from the Utility based phase12 model decribed by Chapple and Thall (2019).
#'
#'@param YE Binary indicator vector of efficacy status.
#'@param YT Binary indicator vector of toxicity status.
#'@param Doses Vector of integer Doses given to patients.
#'@param HypermeansEFF Vector of length nDose for dose prior means for efficacy.
#'@param HypermeansTOX Vector of length nDose for dose prior means for toxicity
#'@param Hypervars Length 3 vector of hypervariances.Hypervars(1) contains sigma_0^2, Hypervars(2) contains sigma_mu, Hypervars(3) contains tau - the frailty variance.
#'@param B Number of iterations to run for the MCMC.
#'@return A list of posterior samples after burnin in order: Posterior efficacy dose-vector, Posterior toxicity dose-vector, Posterior correlation.
#'@examples
#'n=100  #Generate Data
#'YE=rbinom(n,1,.6)
#'YT=rbinom(n,1,.2)
#'nDose=5
#'Doses=sample(1:nDose,n,replace=TRUE)
#'##Hyperparameters
#'HypermeansEFF=c(-1,-.5,0,.5,1,2)
#'HypermeansTOX=HypermeansEFF
#'Hypervars=c(1,16,1)
#'B=100
#'UTEFFTOX(YE, YT,Doses,HypermeansEFF,HypermeansTOX, Hypervars, B)
#'@export
UTEFFTOX <- function(YE, YT, Doses, HypermeansEFF, HypermeansTOX, Hypervars, B) {
    .Call('_Phase12Compare_UTEFFTOX', PACKAGE = 'Phase12Compare', YE, YT, Doses, HypermeansEFF, HypermeansTOX, Hypervars, B)
}

#' Determines the optimal dose to assign the next patient cohort.
#'
#' This function returns the optimal acceptable dose number to assign the next patient cohort or stops the trial if no dose is deemed acceptable.
#' @param YE   Vector containing observed efficacy indicators.
#' @param YT   Vector containing observed toxicity indicators.
#' @param Doses Vector containing numbered Doses of patients in trial.
#' @param Dose Vector containing the standardized doses considered.
#' @param DosesTried Binary vector corresponding to which doses have been tried.
#' @param Hypermeans Vector containing prior hypermeans of length 6 for Eff-Tox parameters.
#' @param Hypervars Vector containing prior hypervariances of length 6 for Eff-Tox parameters.
#' @param Contour Vector containing 4 entries used to make the desireability function. Contour[1] contains a desired toxicity probability given efficacy, Countour[2] contains a desired efficacy probability given toxicity, and (Contour[3],Contour[4]) is an equally desireable pair of efficacy and toxicity probabilities that are non-zero or one.
#' @param PiLim Vector of length two with PiLim[1] containing the acceptable lower limit on efficacy probability and PiLim[2] containing the acceptable upper limit on toxicity probability.
#' @param ProbLim Vector of length two with ProbLim[1] containing the probability cutoff for acceptable efficacy probability and ProbLim[2] containing the probability cutoff for acceptable toxicity probability.
#' @param B Number of iterations to perform in the MCMC.
#' @return The optimal dose level to administer the next patient cohort.
#'@examples
#'##Doses, YE,YT
#'Doses= c(1,1,1,2,2,2,1,1,1,3,3,3,1,1,1,2,2,2)
#'YE = c(0,0,1,1,1,0,0,0,0,1,1,1,0,0,1,1,1,0)
#'YT=c(0,0,0,1,1,0,1,0,0,1,1,1,0,0,0,1,0,0)
#'##Vector of Numerical Doses
#'Dose = c(1,2,3,3.5,5)
#'Dose=(Dose-mean(Dose))/sd(Dose)
#'##Five doses, but only 3 tried so we have
#'DosesTried=c(1,1,1,0,0)
#'## Contour Vector
#'Contour = c(.35, .75,.7,.4)
#'##Hypermeans
#'Hypermeans = c(.022,3.45,0,-4.23,3.1,0)
#'Hypervars = c(2.6761, 2.6852, .2, 3.1304, 3.1165, 1)
#'Hypervars=Hypervars^2
#'##Acceptability Criteria
#'PiLim = c(.3,.4)
#'ProbLim=c(.1,.1)
#'##Number of iterations
#'B=2000
#'AssignEffTox(YE,YT, Doses, Dose, DosesTried, Hypermeans,  Hypervars, Contour, PiLim,  ProbLim, B )
#'@export
AssignEffTox <- function(YE, YT, Doses, Dose, DosesTried, Hypermeans, Hypervars, Contour, PiLim, ProbLim, B) {
    .Call('_Phase12Compare_AssignEffTox', PACKAGE = 'Phase12Compare', YE, YT, Doses, Dose, DosesTried, Hypermeans, Hypervars, Contour, PiLim, ProbLim, B)
}

#' Determines the optimal dose to assign the next patient cohort.
#'
#' This function returns the optimal acceptable dose number to assign the next patient cohort or stops the trial if no dose is deemed acceptable.
#' @param YE   Vector containing observed efficacy indicators.
#' @param YT   Vector containing observed toxicity indicators.
#' @param Doses Vector containing numbered Doses of patients in trial.
#' @param Dose Vector containing the standardized doses considered.
#' @param DosesTried Binary vector corresponding to which doses have been tried.
#' @param Hypermeans Vector containing prior hypermeans of length 6 for Eff-Tox parameters.
#' @param Hypervars Vector containing prior hypervariances of length 6 for Eff-Tox parameters.
#' @param UT 2x2 utility matrix.
#' @param PiLim Vector of length two with PiLim[1] containing the acceptable lower limit on efficacy probability and PiLim[2] containing the acceptable upper limit on toxicity probability.
#' @param ProbLim Vector of length two with ProbLim[1] containing the probability cutoff for acceptable efficacy probability and ProbLim[2] containing the probability cutoff for acceptable toxicity probability.
#' @param B Number of iterations to perform in the MCMC.
#' @return The optimal dose level to administer the next patient cohort.
#'@examples
#'##Doses, YE,YT
#'Doses= c(1,1,1,2,2,2,1,1,1,3,3,3,1,1,1,2,2,2)
#'YE = c(0,0,1,1,1,0,0,0,0,1,1,1,0,0,1,1,1,0)
#'YT=c(0,0,0,1,1,0,1,0,0,1,1,1,0,0,0,1,0,0)
#'##Vector of Numerical Doses
#'Dose = c(1,2,3,3.5,5)
#'Dose=(Dose-mean(Dose))/sd(Dose)
#'##Five doses, but only 3 tried so we have
#'DosesTried=c(1,1,1,0,0)
#''UT = matrix(c(38.23529,100,0,61.76471),nrow=2,byrow=TRUE)
#'##Hypermeans
#'Hypermeans = c(.022,3.45,0,-4.23,3.1,0)
#'Hypervars = c(2.6761, 2.6852, .2, 3.1304, 3.1165, 1)
#'Hypervars=Hypervars^2
#'##Acceptability Criteria
#'PiLim = c(.3,.4)
#'ProbLim=c(.1,.1)
#'##Number of iterations
#'B=2000
#'AssignEffTox(YE,YT, Doses, Dose, DosesTried, Hypermeans,  Hypervars, UT, PiLim,  ProbLim, B )
#'@export
AssignEffToxUT <- function(YE, YT, Doses, Dose, DosesTried, Hypermeans, Hypervars, UT, PiLim, ProbLim, B) {
    .Call('_Phase12Compare_AssignEffToxUT', PACKAGE = 'Phase12Compare', YE, YT, Doses, Dose, DosesTried, Hypermeans, Hypervars, UT, PiLim, ProbLim, B)
}

