% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mean.R
\name{mean}
\alias{mean}
\alias{mean.cont_phase_type}
\alias{mean.disc_phase_type}
\alias{mean.mult_cont_phase_type}
\alias{mean.mult_disc_phase_type}
\title{Mean of Phase-Type Distributions}
\usage{
\method{mean}{cont_phase_type}(x, ...)

\method{mean}{disc_phase_type}(x, ...)

\method{mean}{mult_cont_phase_type}(x, v = NULL, ...)

\method{mean}{mult_disc_phase_type}(x, v = NULL, ...)
}
\arguments{
\item{x}{a \code{cont_phase_type}, \code{disc_phase_type},
\code{mult_cont_phase_type} or \code{mult_disc_phase_type} object}

\item{...}{other arguments passed to methods}

\item{v}{NULL, integer or vector.}
}
\value{
This function returns a single value for the mean of univariate phase-type
distributions, or a vector of means for each reward-transformed distribution
of the multivariate phase-type distributions.
}
\description{
Calculates the mean of continuous, discrete and multivariate phase-type
distributions, represented by the \code{cont_phase_type},
\code{disc_phase_type} and \code{mult_cont_phase_type} classes.
}
\details{
For the univariate case (\code{cont_phase_type} and \code{disc_phase_type}),
the mean of the distribution is returned.

In the case of multivariate phase-type distributions three
different usages can be distinguished:
\itemize{
 \item{If \code{v = NULL} (default), the means of all the variables defined by
 the sub-intensity matrix are returned}
 \item{If \code{v} is an integer, then the mean of the variable with the specified index in the
 reward matrix is returned.}
 \item{If \code{v} is a vector, then the means of the variables defined
by those indices will be returned.}
}
}
\examples{
# For univariate continuous phase-type distributions
ph1 <- PH(matrix(c(-3, 0, 0, 1, -2, 0, 0, 1, -1), ncol = 3), c(0.25,0.25,0.5))
mean(ph1)

# For multivariate continuous phase-type distributions
subintensity_matrix <- matrix(c(-3, 0, 0,
                               2, -2, 0,
                               0, 1, -1), nrow = 3, ncol = 3)
reward_matrix = matrix(sample(seq(0, 10), 6), nrow = 3, ncol = 2)
ph2 <- MPH(subintensity_matrix, reward_mat = reward_matrix)
## Mean for both states in the reward matrix
mean(ph2)
## Mean for the first state in the reward matrix
mean(ph2, 1)
## Mean for the second state in the reward matrix
mean(ph2, 2)

}
