% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reads.R
\name{reads}
\alias{reads}
\title{Read and merge spectral data using data.table exclusively}
\usage{
reads(directory, pattern, output_path)
}
\arguments{
\item{directory}{Path to the directory containing files}

\item{pattern}{File pattern to search for (e.g., 'input')}

\item{output_path}{Path to save the processed output}
}
\value{
A merged data.table
}
\description{
Read and merge spectral data using data.table exclusively
}
\examples{
library(data.table)
# Create mock data files with all required columns
mock_data1 <- data.frame(
  treatment = sample(0:1, 50, replace = TRUE),
  var1 = rnorm(50),
  var2 = rnorm(50),
  Scan.date = sample(
    seq.Date(
      from = as.Date('2023-01-01'),
      to = as.Date('2023-12-31'),
      by = 'day'
    ),
    50,
    replace = TRUE
  ),
  Scan.time = format(Sys.time(), "\%H:\%M:\%S"),
  timestamp = Sys.time()  # Add timestamp column
)

mock_data2 <- data.frame(
  treatment = sample(0:1, 50, replace = TRUE),
  var1 = rnorm(50),
  var2 = rnorm(50),
  Scan.date = sample(
    seq.Date(
      from = as.Date('2023-01-01'),
      to = as.Date('2023-12-31'),
      by = 'day'
    ),
    50,
    replace = TRUE
  ),
  Scan.time = format(Sys.time(), "\%H:\%M:\%S"),
  timestamp = Sys.time()  # Add timestamp column
)

# Save mock data to temporary CSV files
temp_dir <- tempdir()
file1 <- file.path(temp_dir, "input_file1.csv")
file2 <- file.path(temp_dir, "input_file2.csv")
fwrite(mock_data1, file1)
fwrite(mock_data2, file2)

# Run the reads() function on mock CSV data
merged_data <- reads(
  directory = temp_dir,
  pattern = "input",
  output_path = tempfile(fileext = ".csv")
)
head(merged_data)
}
