% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deliveryPrediction.R
\name{deliveryPrediction}
\alias{deliveryPrediction}
\title{Predict Delivery Days in Accelerometry Data}
\usage{
deliveryPrediction(df, feats, model = c("RF", "GLM", "NN"), ...)
}
\arguments{
\item{df}{A dataframe. The source accelerometry dataset, in dataframe format.}

\item{feats}{A dataframe. Features output from the \code{\link{deliveryFeatures}} function.}

\item{model}{A character. Indicates which prediction model to use.
\sQuote{RF} is a Random Forest. \sQuote{GLM} is a logistic regression, and
\sQuote{NN} is a convolutional neural network.}

\item{\dots}{not used at this time}
}
\value{
A dataframe is returned with a predicted probability of each day being a delivery activity day.
}
\description{
The function predicts the probability of each day in an accelerometry dataset being 
caused from delivery activity instead of human activity. 
The prediction model can be selected from one of three models, 
a Random Forest, a logistic regression, and a convolutional neural network (default: Random Forest).
}
\details{
Function works for data consisting of one or multiple unique trials.
}
\note{
The input dataframe should have the following columns: 
\sQuote{TimeStamp}, \sQuote{axis1}, \sQuote{axis2}, \sQuote{axis3}, \sQuote{vm},
where \sQuote{vm} is the vector magnitude of axes 1, 2, and 3. 
Dataframe should also be formatted to 60 second epoch.
}
\examples{
data(deliveryData)

deliveryDataProcessed <- deliveryPreprocess(df = deliveryData)
deliveryDataFeats <- deliveryFeatures(df = deliveryDataProcessed)
deliveryPrediction(deliveryDataProcessed, deliveryDataFeats)

}
\seealso{
\code{\link{deliveryFeatures}}, \code{\link{deliveryPred}}
}
\author{
Ryan Moore \email{ryan.moore@vumc.org},
Cole Beck \email{cole.beck@vumc.org}, and
Leena Choi \email{leena.choi@Vanderbilt.Edu}
}
