% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lab_utilities.R
\name{calculate_reagents}
\alias{calculate_reagents}
\title{Calculate Master Mix Reagents}
\usage{
calculate_reagents(
  n_samples,
  n_genes,
  replicates = 3,
  rxn_volume = 20,
  dead_volume_pct = 10
)
}
\arguments{
\item{n_samples}{Number of biological samples.}

\item{n_genes}{Number of genes (targets + reference).}

\item{replicates}{Number of technical replicates (usually 3).}

\item{rxn_volume}{Total volume per well (e.g., 20 uL).}

\item{dead_volume_pct}{Percentage of extra mix to prepare for pipetting error (default 10\%).}
}
\value{
A data frame containing the mix recipe.
}
\description{
Generates a recipe for your qPCR Master Mix based on sample count.
}
\examples{
# Plan for 12 samples, 2 genes, standard 20uL reaction
calculate_reagents(n_samples = 12, n_genes = 2)

# Adjust for a 10uL reaction volume and 15\% dead volume
calculate_reagents(12, 2, rxn_volume = 10, dead_volume_pct = 15)
}
