% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml_helper.R
\name{ml_make_ensemble}
\alias{ml_make_ensemble}
\title{NA-tolerant ensemble blender (row-wise)}
\usage{
ml_make_ensemble(..., weights = NULL)
}
\arguments{
\item{...}{Two or more model objects each with \verb{$fit}/\verb{$predict}.}

\item{weights}{Optional numeric vector of blend weights (recycled).}
}
\value{
A list with \verb{$fit} and \verb{$predict} closures for the ensemble.
}
\description{
Creates an equal- or user-weighted blend of multiple model objects produced
by \code{\link[=ml_make_model]{ml_make_model()}}. The returned \code{fit} trains each component; \code{predict}
combines component predictions with an NA-safe weighted average.
}
\examples{
\dontrun{
ens <- ml_make_ensemble(ml_make_model("ridge"),
                        ml_make_model("rf"),
                        ml_make_model("xgboost"))
}
}
