% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sup_prob.R
\name{SupProb}
\alias{SupProb}
\title{Superiority Probability}
\usage{
SupProb(
  cens_prop,
  n,
  med1 = NULL,
  shape1 = NULL,
  rate1 = NULL,
  med2 = NULL,
  shape2 = NULL,
  rate2 = NULL,
  info_reps = 50,
  margin = 0,
  use_exp_calc = TRUE
)
}
\arguments{
\item{cens_prop}{Expected censoring proportion.}

\item{n}{Sample size.}

\item{med1}{Median for treatment arm 1, assuming shape1 = 1. Overwrites
shape and rate if supplied.}

\item{shape1}{Shape parameter for arm 1.}

\item{rate1}{Rate parameter for arm 1.}

\item{med2}{Median for treatment arm 2, assuming shape2 = 1. Overwrites
shape and rate if supplied.}

\item{shape2}{Shape parameter for arm 2.}

\item{rate2}{Rate parameter for arm 2.}

\item{info_reps}{Replicates used for estimating the observed information
matrix.}

\item{margin}{Margin of practical equivalence.}

\item{use_exp_calc}{If both shape parameters are 1, should the calculations
be performed assuming an exponential distribution for the time to event in
each arm? Default is TRUE.}
}
\value{
Numeric equivalence probability.
}
\description{
Probability of selecting the more effective treatment as 
pr(median2 - median1 >= margin) + 0.5 * pr(abs(median2 - median1) < margin).
}
\examples{
# Calculation in the case of exponentials with no margin.
prob <- SupProb(
  cens_prop = 0.15,
  n = 100,
  med1 = 9,
  med2 = 12,
)

# Calculation in the case of exponentials with a 2 month margin.
# The probability should be lower than in the absence of a margin.
prob <- SupProb(
  cens_prop = 0.15,
  n = 100,
  med1 = 9,
  med2 = 12,
  margin = 2
)

# Calculation in the case of Weibulls with a 2 month margin.
prob <- SupProb(
  cens_prop = 0.15,
  n = 100,
  shape1 = 2.8,
  rate1 = 0.10,
  shape2 = 4.0,
  rate2 = 0.08,
  margin = 2
)
}
