% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{piecewise_data}
\alias{piecewise_data}
\title{Simulated Data and Parameters for a Piecewise Example}
\format{
A list with 2 components:
\describe{
\item{df}{A data frame with 3,000 rows and 2 variables (the simulated data).}
\item{theta0}{A list of 5 elements containing the true parameters used for simulation.}
}
}
\source{
Generated synthetically by the package authors.
}
\usage{
piecewise_data
}
\description{
A list containing a second simulated dataset (\code{df}) and its ground-truth
parameters (\code{theta0}). This dataset is generated from a **piecewise linear
model**, where the continuous predictor \code{x} is segmented into 6 bins, and
different intercept and slope coefficients are applied to each segment.

The dataset \code{df} contains $N = 3000$ observations.
}
\details{
The underlying model for the response \eqn{\bold{Y}} is:
\deqn{\bold{Y} = \bold{X}_{Fe}\bold{\beta} + \bold{X}_{Lat}\bold{\alpha}_{Lat} + \bold{\epsilon}}
where \eqn{\bold{X}_{Fe}} is the global intercept, and \eqn{\bold{X}_{Lat}}\eqn{\bold{\alpha}_{Lat}} models the piecewise relationship of \code{x} across the 6 categories defined in \code{theta0$Lat}. The error term \eqn{\bold{\epsilon} ~ N(0, 1)}.
}
\section{\code{df} Data Variables}{

\describe{
\item{x}{A continuous predictor, uniformly distributed between -3 and 3.}
\item{Y}{The **Simulated Response Variable** defined by the piecewise linear model.}
}
}

\section{\code{theta0} Parameters}{

The list \code{theta0} holds the true values used for simulation, including:
\itemize{
\item \code{beta}: True global intercept (i.e., (0.5)).
\item \code{Lat}: The categorical factor (1 to 6) derived from segmenting \code{x}.
\item \code{alphaLat}: Vector of $2 * 6 = 12$ coefficients defining the specific intercept and slope for \code{x} within each of the 6 segments.
}
}

\keyword{datasets}
