% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/profileGLMM_postProcess.R
\name{profileGLMM_postProcess}
\alias{profileGLMM_postProcess}
\title{Post-process MCMC Output for Profile GLMM}
\usage{
profileGLMM_postProcess(
  MCMC_Obj,
  modeClus = "NG",
  comp_cooc = TRUE,
  alpha = 0.05
)
}
\arguments{
\item{MCMC_Obj}{An object of class \code{pglmm_mcmc} (the output of \code{profileGLMM_Gibbs}).}

\item{modeClus}{A character string specifying the clustering method.
Options are \code{'NG'} (Ng's spectral clustering, default) or \code{'LS'} (Least Squares clustering).}

\item{comp_cooc}{A logical value. If \code{TRUE} (default), the co-occurrence matrix is computed
and clustering is performed. If \code{FALSE}, only the population parameters are processed.}

\item{alpha}{A numeric value between 0 and 1, specifying the significance level for
credible intervals. Defaults to \code{0.05} (95\% CIs).}
}
\value{
An object of class \code{pglmm_fit}. This is a list containing:
\itemize{
  \item \code{coocMat}: The co-occurrence matrix of MCMC cluster assignments.
  \item \code{clust}: A list of representative clustering results (if \code{comp_cooc = TRUE}),
  including the optimal partition (\code{Zstar}), number of clusters (\code{Kstar}),
  and cluster-specific parameters (\code{cen}, \code{pvec}, \code{gamma}).
  \item \code{pop}: A list containing the posterior means and credible intervals for fixed effects.
}
}
\description{
This function performs essential post-processing of the MCMC output generated by
\code{profileGLMM_Gibbs}. It calculates posterior means and credible intervals for fixed effects
and, optionally, computes a representative cluster partition using Least Squares (LS) or
Ng's spectral clustering (NG). It also estimates cluster characteristics such as centroids,
probability vectors, and outcome effects for the chosen partition.
}
\examples{
# Load MCMC_Obj, the result of profileGLMM_Gibbs()
data("examp")
MCMC_Obj = examp$MCMC_Obj

# Post-process the results
post_Obj = profileGLMM_postProcess(MCMC_Obj, modeClus='LS')

# Removing the cooc matrix to save space
post_Obj$coocMat = NULL

}
