% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Asian.R
\name{AsianBS}
\alias{AsianBS}
\title{Asian option valuation via Black-Scholes (BS) model}
\usage{
AsianBS(o = OptPx(Opt(Style = "Asian")))
}
\arguments{
\item{o}{An object of class \code{OptPx}}
}
\value{
A list of class \code{AsianBS} consisting of the original \code{OptPx} object
and the option pricing parameters \code{M1}, \code{M2}, \code{F0}, and \code{sigma}
as well as the computed option price \code{PxBS}.
}
\description{
Price Asian option using BS model
}
\details{
This pricing algorithm assumes average price is calculated continuously.
}
\examples{
(o = AsianBS())$PxBS #Price = ~4.973973,  using default values

 o = Opt(Style='Asian',S0=100,K=90,ttm=3)
 (o = AsianBS(OptPx(o,r=0.03,q=0,vol=0.3)))$PxBS

 o = Opt(Style='Asian',Right='P',S0=100,K=110,ttm=0.5)
 (o = AsianBS(OptPx(o,r=0.03,q=0.01,vol=0.3)))$PxBS

 #See J.C.Hull, OFOD'2014, 9-ed, ex.26.3, pp.610. The price is 5.62.
 o = Opt(Style='Asian',Right='Call',S0=50,K=50,ttm=1)
 (o = AsianBS(OptPx(o,r=0.1,q=0,vol=0.4)))$PxBS
}
\author{
Xinnan Lu, Department of Statistics, Rice University, Spring 2015
}
\references{
Hull, John C., \emph{Options, Futures and Other Derivatives}, 9ed, 2014. Prentice Hall.
ISBN 978-0-13-345631-8, \url{http://www-2.rotman.utoronto.ca/~hull/ofod/index.html} pp.609-611.
}

