% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Lookback.R
\name{LookbackBS}
\alias{LookbackBS}
\title{Lookback option valuation with Black-Scholes (BS) model}
\usage{
LookbackBS(o = OptPx(Opt(Style = "Lookback")), Smax = 50, Smin = 50,
  Type = c("Floating", "Fixed"))
}
\arguments{
\item{o}{An object of class \code{OptPx}.}

\item{Smax}{The maximum asset price observed to date.}

\item{Smin}{The minimum asset price observed to date.}

\item{Type}{Specifies the Lookback option as either Floating or Fixed- default argument is Floating.}
}
\value{
An original \code{OptPx} object with \code{PxBS} field as the price of the option
and user-supplied \code{Smin}, \code{Smax}, and \code{Type} lookback parameters attached.
}
\description{
Calculates the price of a lookback option using a BSM-adjusted algorithm;
Carries the assumption that the asset price is observed continuously.
}
\details{
To price the lookback option, we require the Smax/Smin, S0, r, q, vol, and ttm arguments
from the object classes defined in the package. An example of a complete OptLookback option object can be found in the examples.
}
\examples{
(o = LookbackBS())$PxBS
  LookbackBS(OptPx(Opt(Style = 'Lookback'))) #Uses default arguments

  # See Hull 9e Example 26.2, p.608; gives price of 7.79
  o = Opt(Style = 'Lookback', S0 = 50, ttm= .25, Right = "Put")
  o = OptPx(o,r = .1, vol = .4)
  o = LookbackBS(o, Type = "Floating")

  # See Hull 9e Example 26.2, p.608; gives price of 8.04
  o = Opt(Style = 'Lookback', S0 = 50, ttm= .25, Right = "Call")
  o = OptPx(o, r = .1, vol = .4)
  o = LookbackBS(o, Type = "Floating")

  # Price = 17.7129
  o = Opt(Style = 'Lookback', S0 = 50, ttm= 1, Right = "Put", K = 60)
  o = OptPx(o,r = .05, q = .02, vol = .25)
  o = LookbackBS(o, Type = "Fixed")

  # Price = 8.237
  o = Opt(Style = 'Lookback', S0 = 50, ttm= 1, Right = "Call", K = 55)
  o = OptPx(o,r = .1, q = .02, vol = .25)
  o = LookbackBS(o, Type = "Fixed")
}
\author{
Richard Huang, Department of Statistics, Rice University, Spring 2015
}
\references{
Hull, J.C., \emph{Options, Futures and Other Derivatives}, 9ed, 2014. Prentice Hall.
ISBN 978-0-13-345631-8, \url{http://www-2.rotman.utoronto.ca/~hull/ofod/index.html}.
}

