% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QHawkDove.R
\name{QHawkDove}
\alias{QHawkDove}
\title{Quantum Hawk and Dove game}
\usage{
QHawkDove(p, q, moves, v, j, D)
}
\arguments{
\item{p}{a real number between 0 and 1 including the end points}

\item{q}{a real number between 0 and 1 including the end points}

\item{moves}{a list of matrics}

\item{v}{a number}

\item{j}{a number}

\item{D}{a number}
}
\value{
A vector consisting of the expected payoffs to Alice and Bob as its elements calculated according to the probabilities \code{p} and \code{q} provided as inputs.
}
\description{
This function returns the expected payoffs to Alice and Bob with respect to the probabilities \code{p} and \code{q}. \code{p+q} should equal 1 and \code{moves} is a list of two possible strategies for each of the players and \code{v, j, D} are the value of resource, cost of injury and cost of displaying respectively.
}
\examples{
init()
moves <- list(Q$I2, sigmaX(Q$I2))
QHawkDove(0, 1, moves, 50, -100, -10)
QHawkDove(0, 0, moves, 50, -100, -10)

}
\references{
\url{https://arxiv.org/pdf/quant-ph/0506219.pdf}\cr
\url{https://arxiv.org/pdf/quant-ph/0208069.pdf}\cr
\url{https://arxiv.org/pdf/quant-ph/0108075.pdf}\cr
}
