% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WangF.R
\name{WangF}
\alias{WangF}
\title{To perform QTL mapping with wang method}
\usage{
WangF(
  pheRaw = NULL,
  genRaw = NULL,
  mapRaw1 = NULL,
  yygg1 = NULL,
  flagRIL = NULL,
  cov_en = NULL,
  Population = NULL,
  WalkSpeed = NULL,
  CriLOD = NULL
)
}
\arguments{
\item{pheRaw}{phenotype matrix.}

\item{genRaw}{genotype matrix.}

\item{mapRaw1}{linkage map matrix.}

\item{yygg1}{the transformed covariate matrix.}

\item{flagRIL}{if RIL or not.}

\item{cov_en}{raw covariate matrix.}

\item{Population}{population flag.}

\item{WalkSpeed}{Walk speed for Genome-wide Scanning.}

\item{CriLOD}{Critical LOD scores for significant QTL.}
}
\value{
a list
}
\description{
To perform QTL mapping with wang method
}
\examples{
data(DHdata)
readraw<-Readdata(file=DHdata,fileFormat="GCIM",
method="GCIM",filecov=NULL,MCIMmap=NULL,MultiEnv=FALSE)
DoResult<-Dodata(fileFormat="GCIM",Population="DH",
method="GCIM",Model="Random",readraw,MultiEnv=FALSE)
ws<-WangF(pheRaw=DoResult$pheRaw,genRaw=DoResult$genRaw,
mapRaw1=DoResult$mapRaw1,yygg1=DoResult$yygg1,
flagRIL=DoResult$flagRIL,cov_en=DoResult$cov_en,
Population="DH",WalkSpeed=1,CriLOD=2.5)
}
