% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/q.sort.R
\name{q.sort}
\alias{q.sort}
\title{Sort and truncate genes according to the strength of gene-environment interaction}
\usage{
q.sort(x, y, method = "linear", n.gene = ncol(x), trunc = 1)
}
\arguments{
\item{x}{A data matrix (raw: samples, col: genes).}

\item{y}{A vector of an environment in which the samples were collected.}

\item{method}{A string to specify the method of regression for calculating R-squared values.
"linear" (default), "quadratic" or "cubic" regression model can be specified.}

\item{n.gene}{The number of genes to be included in QuEST model (default: ncol(x)).}

\item{trunc}{a threshold to be truncated (default: 1).}
}
\value{
A data matrix (raw: samples, col: sorted genes)
}
\description{
Sort and truncate genes according to the strength of gene-environment interaction
}
\examples{
data(Pinus)
train <- q.clean(Pinus$train)
target <- Pinus$target
cor(target, train[, 1])

train <- q.sort(train, target, trunc = 0.5)
cor(target, train[, 1])
}
\author{
Takahiko Koizumi
}
