% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/peer.gen.R, R/peer.lin.R, R/peer.q.R
\name{summary.genpeer}
\alias{summary.genpeer}
\alias{print.summary.genpeer}
\alias{print.genpeer}
\alias{summary.linpeer}
\alias{print.summary.linpeer}
\alias{print.linpeer}
\alias{summary.qpeer}
\alias{print.summary.qpeer}
\alias{print.qpeer}
\title{Summary for the Estimation of Quantile Peer Effects Models}
\usage{
\method{summary}{genpeer}(
  object,
  fullparameters = TRUE,
  diagnostic = FALSE,
  diagnostics = FALSE,
  ...
)

\method{print}{summary.genpeer}(x, ...)

\method{print}{genpeer}(x, ...)

\method{summary}{linpeer}(
  object,
  fullparameters = TRUE,
  diagnostic = FALSE,
  diagnostics = FALSE,
  ...
)

\method{print}{summary.linpeer}(x, ...)

\method{print}{linpeer}(x, ...)

\method{summary}{qpeer}(
  object,
  fullparameters = TRUE,
  diagnostic = FALSE,
  diagnostics = FALSE,
  ...
)

\method{print}{summary.qpeer}(x, ...)

\method{print}{qpeer}(x, ...)
}
\arguments{
\item{object}{An object of class \code{\link{qpeer}}.}

\item{fullparameters}{A logical value indicating whether all parameters should be summarized (may be useful for the structural model).}

\item{diagnostics, diagnostic}{Logical. Should diagnostic tests for the instrumental-variable regression be performed?
These include an F-test of the first-stage regression for weak instruments, a Wu-Hausman test for endogeneity,
and a Hansen's J-test for overidentifying restrictions (only if there are more instruments than regressors).}

\item{...}{Further arguments passed to or from other methods.}

\item{x}{An object of class \code{\link{summary.qpeer}} or \code{\link{qpeer}}.}
}
\value{
A list containing:
\item{model.info}{A list with information about the model, such as the number of subnets, number of observations, and other key details.}
\item{coefficients}{A summary of the estimates, standard errors, and p-values.}
\item{diagnostics}{A summary of the diagnostic tests for the instrumental-variable regression if requested.}
\item{KP.cv}{Critical values for the Kleibergen–Paap Wald test (5\% level).}
\item{gmm}{A list of GMM estimation results, including parameter estimates, the covariance matrix, and related statistics.}
}
\description{
Summary and print methods for the class \code{\link{qpeer}}.
}
