% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/growth_summaries.R
\name{summary.gcFitSpline}
\alias{summary.gcFitSpline}
\title{Generic summary function for gcFitSpline objects}
\usage{
\method{summary}{gcFitSpline}(object, ...)
}
\arguments{
\item{object}{object of class \code{gcFitSpline}}

\item{...}{Additional arguments. This has currently no effect and is only meant to fulfill the requirements of a generic function.}
}
\value{
A dataframe with parameters extracted from the nonparametric fit.
}
\description{
Generic summary function for gcFitSpline objects
}
\examples{
# Create random growth dataset
rnd.dataset <- rdm.data(d = 35, mu = 0.8, A = 5, label = 'Test1')

# Extract time and growth data for single sample
time <- rnd.dataset$time[1,]
data <- rnd.dataset$data[1,-(1:3)] # Remove identifier columns

# Perform linear fit
TestFit <- growth.gcFitSpline(time, data, gcID = 'TestFit',
                 control = growth.control(fit.opt = 's'))

summary(TestFit)

}
