% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funcDT.R
\name{extractRefLevelDT}
\alias{extractRefLevelDT}
\title{Extracting the reference level of all or a selected set of the factor columns of a data.table object}
\usage{
extractRefLevelDT(inputDT, categoricalVar = NULL)
}
\arguments{
\item{inputDT}{data.table object containing the data of interest. This is an obligatory argument, without default value.}

\item{categoricalVar}{Character vector containing potential column names of the 'inputDT' argument. The default value is NULL.}
}
\value{
A named list is returned, with as names the different valid factor column names, either of the whole 'inputDT' argument, either of the factor variables of which the names are listed in 'categoricalVar' argument, containing a character vector of length 1 with the reference level of the respective factor. In case that the 'categoricalVar' argument contains column names that aren't factors, a warning is thrown. An empty is list is returned when no valid factors (with or without the 'categoricalVar' selection turned on) are found.
}
\description{
Extracting the reference level of all or a selected set of the factor columns of a data.table object
}
\examples{
library(data.table)
inputDT <- as.data.table(data.frame(x = LETTERS[11:20], y = LETTERS[1:10]))
asFactorDT(inputDT, c('x', 'y'))

extractRefLevelDT(inputDT)
\donttest{extractRefLevelDT(inputDT, c('x', 'y'))
extractRefLevelDT(inputDT, c('x', 'y1'))}

inputDT <- as.data.table(data.frame(x = seq(1, 20, 2), y = LETTERS[1:10]))
asFactorDT(inputDT, c('y'))
extractRefLevelDT(inputDT)

inputDT <- as.data.table(data.frame(x = seq(1, 20, 2), y = seq(2, 21, 2)))
extractRefLevelDT(inputDT)
\donttest{extractRefLevelDT(inputDT, c('x', 'y'))}
}
