% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auc_trf.r
\name{auc_trf}
\alias{auc_trf}
\title{auc_trf function}
\usage{
auc_trf(R2, se, kv)
}
\arguments{
\item{R2}{R2 or coefficient of determination on the observed scale}

\item{se}{Standard error of R2}

\item{kv}{Population prevalence}
}
\value{
This function will transform the observed R2 and its s.e between to AUC. Output from the command is the lists of outcomes.
\item{auc}{Transformed AUC}
\item{se}{SE of transformed AUC}
}
\description{
This function transforms the observed scale predictive ability (R2)
and its standard error (SE) to AUC with its SE
}
\examples{
#To get the transformed AUC

output=auc_trf(0.04, 0.002, 0.05)
output

#output$auc (transformed AUC)
#0.7522887

#output$se (se of transformed AUC)
#0.005948364
}
\references{
Wray, Naomi R., et al. "The genetic interpretation of area under the ROC curve in genomic profiling." PLoS genetics 6.2 (2010): e1000864.

Lee, Sang Hong, et al. "A better coefficient of determination for genetic profile analysis." Genetic epidemiology 36.3 (2012): 214-224.
}
\keyword{AUC}
\keyword{R2}
\keyword{Transformation}
\keyword{observed}
\keyword{of}
\keyword{to}
